#!/bin/bash

logserverinstance=0
slpinstance=0
serverinstance=0
retval=0

OSNAME=`uname -s`
if [ "$OSNAME" = "Darwin" ] || [ "$OSNAME" = "SunOS" ] 
then
 logserverinstance=`ps -aef |grep UWMgrServer| grep logserver | grep -v grep | grep -v "PID COMMAND" | wc -l` 
 slpinstance=`ps -aef |grep UWMgrServer| grep slp | grep -v grep | grep -v "PID COMMAND" | wc -l `
 serverinstance=` ps -aef |grep UWMgrServer| grep -v logserver | grep -v slp | grep -v "PID COMMAND" | grep -v grep | wc -l`
elif [ "$OSNAME" = "FreeBSD" ]
then
 logserverinstance=`ps -ax |grep UWMgrServer| grep logserver | grep -v grep | grep -v "PID COMMAND" | wc -l` 
 slpinstance=`ps -ax |grep UWMgrServer| grep slp | grep -v grep | grep -v "PID COMMAND" | wc -l `
 serverinstance=` ps -ax |grep UWMgrServer| grep -v logserver | grep -v slp | grep -v "PID COMMAND" | grep -v grep | wc -l`
else
 logserverinstance=`ps -C UWMgrServer -o pid,args| grep "run=logserver" | grep -v grep | grep -v "PID COMMAND" | wc -l `
 slpinstance=`ps -C UWMgrServer -o pid,args| grep "run=slp" | grep -v grep | grep -v "PID COMMAND" | wc -l` 
 serverinstance=`ps -C UWMgrServer -o pid,args | grep -v "run=logserver" | grep -v "run=slp" | grep -v "PID COMMAND" | grep -v "grep" | wc -l`
fi

if [ "$OSNAME" = "Darwin" ] || [ "$OSNAME" = "FreeBSD" ]
then
	mkdir -p /var/log/chelsio
fi

if [ $logserverinstance -eq 0 ]
then
	LD_LIBRARY_PATH=$LD_LIBRARY_PATH:.
	export LD_LIBRARY_PATH
	cd `dirname $0`
	./UWMgrServer --run=logserver
else
	echo " Already UWMgrServer --run=logserver is running.."
	retval=1
fi

if [ $slpinstance -eq 0 ]
then
	LD_LIBRARY_PATH=$LD_LIBRARY_PATH:.
	export LD_LIBRARY_PATH
	cd `dirname $0`
	if [ "$OSNAME" =  "Darwin" ] 
	then  
		./UWMgrServer --run=slp  1>/dev/null
	else 
		./UWMgrServer --run=slp
	fi
else
	echo " Already UWMgrServer --run=slp is running.."
	retval=1
fi

if [ $serverinstance -eq 0 ]
then
	LD_LIBRARY_PATH=$LD_LIBRARY_PATH:.
	export LD_LIBRARY_PATH
	cd `dirname $0`
	if [ "$OSNAME" =  "Darwin" ] 
	then  
		./UWMgrServer  1>/dev/null
	else 
		./UWMgrServer
	fi
else
	echo " Already UWMgrServer is running.."
	retval=1
fi

exit $retval

