from XenBridgeConfFile import XenBridgeConf

def index(req, **kwargs):
    data = {}
    try:
        data['sid'] = kwargs['sid']
        data['ip'] = kwargs['ip']
        data['action'] = kwargs['action']
        data['type'] = kwargs['type']
    except:
        return '-1'
    
    if data['action'] == 'get':
        return invoke_get_xen_tree(data) 
    elif data['action'] == 'del_bridge':
        try:
            data['id'] = kwargs['id']
        except:
            return '-1'
        return invoke_delete_bridge(data)
    elif data['action'] == 'del_vif':
        try:
            data['id'] = kwargs['id']
        except:
            return '-1'
        return invoke_delete_vif(data) 

def invoke_get_xen_tree(data):
    obj = XenBridgeConf(data['sid'], data['ip'], data['type'])
    return obj.get_xen_tree()

def invoke_delete_bridge(data):
    obj = XenBridgeConf(data['sid'], data['ip'], data['type'])
    return obj.delete_bridge(data['id'])

def invoke_delete_vif(data):
    obj = XenBridgeConf(data['sid'], data['ip'], data['type'])
    return obj.delete_vif(data['id'])