from WinSwitchConfFile import WinSwitchConf

def index(req, **kwargs):
    data = {}
    try:
        data['sid'] = kwargs['sid']
        data['ip'] = kwargs['ip']
        data['action'] = kwargs['action']
        data['type'] = kwargs['type']
    except:
        return '-1'
    
    if data['action'] == 'get':
        return invoke_get_win_tree(data) 
    elif data['action'] == 'del_switch':
        try:
            data['id'] = kwargs['id']
        except:
            return '-1'
        return invoke_delete_switch(data)
    elif data['action'] == 'del_vif':
        try:
            data['id'] = kwargs['id']
        except:
            return '-1'
        return invoke_delete_vif(data) 
    
    elif data['action'] == 'detach_vm':
        try:
            data['vnic_mac'] = kwargs['vnic_mac']
            data['vmid'] = kwargs['vmid']
            data['name_label'] = kwargs['name_label']
        except:
            return '-1'
        return invoke_detach_vm(data) 

def invoke_get_win_tree(data):
    obj = WinSwitchConf(data['sid'], data['ip'], data['type'])
    return obj.get_win_tree()

def invoke_delete_switch(data):
    obj = WinSwitchConf(data['sid'], data['ip'], data['type'])
    return obj.delete_switch(data['id'])

def invoke_delete_vif(data):
    obj = WinSwitchConf(data['sid'], data['ip'], data['type'])
    return obj.delete_vif(data['id'])

def invoke_detach_vm(data):
    obj = WinSwitchConf(data['sid'], data['ip'], data['type'])
    return obj.detach_vm(data)
