import os

import logging
import settings
logging.basicConfig(filename=settings.log_path,level=logging.DEBUG)

def index(req, **param):

    try:
        sid = param['sid']
        ip = param['ip']
        username = param['user']
        key_file = req.form['sl_file_input']
    except:
        return '-1'
    
    fname = 'chkeyfile_%s.key'%(ip.replace('.','_'))
    upload_file(sid, ip, username , key_file , fname)
    
    req.content_type = "application/xml"
    return upload_key(sid, ip, username , fname)

def upload_file(sid, ip, username , key_file , fname):
    
    # Test if the file was uploaded
    if key_file.filename:
        # build absolute path to files directory
        dir_path = '%s%s'%(settings.document_root_path,username)
        open(os.path.join(dir_path, fname), 'wb').write(key_file.file.read())
        message = 'The file "%s" was uploaded successfully in the spscified user path by python' % fname
        logging.info(message)
    else:
        message = 'No file was uploaded'
        logging.info(message)
    

def upload_key(sid, ip, username , fname):
    import SysSummary    
    obj = SysSummary.SysSummary( sid, ip )
    return obj.upload_licensekey( username , fname  )    
