from DNSGatewayFile import DNSGatewayInfo

import logging
import settings
logging.basicConfig(filename=settings.log_path,level=logging.DEBUG)

def index(req, **param):
    data = {}

    try:
        data['sid'] = param['sid']
        data['umip'] =  param['umip']
        data['action'] = param['action']
    except:
        return '-1'
    
    if data['action'] == 'ModifyGateWay' or data['action'] == 'AddGateWay':
        
        try:
            data['ifName'] = param['ifName']
            data['gw'] = param['gw']
        except:
            return '-1'
        
        data['ipversion'] = 'ipv4'
        return invoke_set_gateway(data)
    
    elif data['action'] == 'ModifyDns':

        try:
            data['ifName'] = param['ifName']
            data['dns'] = param['dns']
            data['newdns'] = param['newdns']
        except:
            return '-1'
        
        data['ipversion'] = 'ipv4'
        data['reqType'] = 2
        return invoke_set_dns(data)
    
    elif data['action'] == 'DeleteDns':

        try:
            data['ifName'] = param['ifName']
            data['dns'] = param['dns']
        except:
            return '-1'
        
        data['ipversion'] = 'ipv4'
        data['reqType'] = 3
        
        #Not required for deleting Dns
        data['newdns'] = ''
        return invoke_del_dns(data)
        
    elif data['action'] == 'AddDns':

        try:
            data['ifName'] = param['ifName']
            data['dns'] = param['dns']
        except:
            return '-1'
        
        data['ipversion'] = 'ipv4'
        data['reqType'] = 1
        
        #Not required for Adding Dns
        data['newdns'] = ''
        return invoke_add_dns(data)
    
    return '-1'
        
def invoke_set_gateway(data):
    obj = DNSGatewayInfo(data['sid'],data['umip'])
    return obj.set_gateway(data)

def invoke_set_dns(data):
    obj = DNSGatewayInfo(data['sid'],data['umip'])
    return obj.set_dns(data)

def invoke_del_dns(data):
    obj = DNSGatewayInfo(data['sid'],data['umip'])
    return obj.del_dns(data)

def invoke_add_dns(data):
    obj = DNSGatewayInfo(data['sid'],data['umip'])
    return obj.add_dns(data)
