import logging
import settings
logging.basicConfig(filename=settings.log_path,level=logging.DEBUG)

def index(req, **param):
    data = {}

    try:
        data['sid'] = param['sid']
        data['umip'] =  param['umip']
        data['action'] = param['action']
    except:
        return '-1'
    
    if data['action'] == 'static':
        
        try:
            data['ifName'] =  param['ifName']
            data['ip'] = param['setip']
            data['mask'] = param['mask']
        except:
            return '-1'
        
        data['reqType'] = 0
        data['ipType'] = 1
        data['ipversion'] = 'ipv4'
        data['newip'] = ''
        return setIp(data)

    elif data['action'] == 'dhcp':
        
        try:
            data['ifName'] =  param['ifName']
        except:
            return '-1'
        
        data['reqType'] = 0
        data['ipType'] = 0
        data['ipversion'] = 'ipv4'
        data['newip'] = ''
        data['ip'] = ''
        data['mask'] = param['mask']
        return setIp(data)
    
    elif data['action'] == 'AdditionalIp':
        
        try:
            data['ifName'] = param['ifName']
            data['ip'] = param['setip']
            data['mask'] = param['mask']
        except:
            return '-1'
        
        data['ipversion'] = 'ipv4'
        data['reqType'] = 1
        
        #Dummy not required for additional Ip
        data['ipType'] = 0
        data['newip'] = ''
        
        return setIp(data)
    
    elif data['action'] == 'ModifyIp':
        
        try:
            data['ifName'] = param['ifName']
            data['ip'] = param['ip']
            data['newip'] = param['newip']
            data['mask'] = param['mask']
        except:
            return '-1'
        
        data['ipversion'] = 'ipv4'
        data['reqType'] = 2
        
        #Dummy not required for additional Ip
        data['ipType'] = 0
        
        return setIp(data)
    
    elif data['action'] == 'DeleteIp':
        
        try:
            data['ifName'] = param['ifName']
            data['ip'] = param['ip']
        except:
            return '-1'
        
        data['ipversion'] = 'ipv4'
        data['reqType'] = 3
        
        #Dummy not required for Deleting Ip
        data['ipType'] = 0
        data['newip'] = ''
        data['mask'] = ''
        
        return setIp(data)
    
    elif data['action'] == 'setmtu':
        
        try:
            data['ifName'] = param['ifName']
            data['mtu'] = param['mtu']
        except:
            return '-1'
        
        return set_mtu_invoke(data)
    
    elif data['action'] == 'setvlan':
        
        try:
            data['ifName'] = param['ifName']
            data['vlan'] = param['vlan']
        except:
            return '-1'
        
        return set_vlan_invoke(data)
    
    elif data['action'] == 'deletevlan':
        
        try:
            data['ifName'] = param['ifName']
            data['ostype'] = param['ostype']
            data['vlan_id'] = param['vlan_id']
        except:
            return '-1'
        
        return delete_vlan_invoke(data)
    
    elif data['action'] == 'delete_team':
        
        try:
            data['ifName'] = param['ifName']
        except:
            return '-1'
        
        return delete_team_invoke(data)
        
    return '-1'
        
def setIp(data):
    from NetworkInfoFile import WebNetworkInfo
    nw_obj = WebNetworkInfo(data['sid'],data['umip'])
    return nw_obj.SetIpAddr(data)

def set_mtu_invoke(data):
    from NetworkInfoFile import WebNetworkInfo
    nw_obj = WebNetworkInfo(data['sid'],data['umip'])
    return nw_obj.set_mtu(data)

def set_vlan_invoke(data):
    from NetworkInfoFile import WebNetworkInfo
    nw_obj = WebNetworkInfo(data['sid'],data['umip'])
    return nw_obj.set_vlan(data)

def delete_vlan_invoke(data):
    from NetworkInfoFile import WebNetworkInfo
    nw_obj = WebNetworkInfo(data['sid'],data['umip'])
    return nw_obj.delete_vlan(data)

def delete_team_invoke(data):
    from NetworkInfoFile import WebNetworkInfo
    nw_obj = WebNetworkInfo(data['sid'],data['umip'])
    return nw_obj.delete_team(data)