#Python import
from xml.dom import minidom
from xml.dom.minidom import Document
import simplejson
import re

#WebGUI Import
from CardSummary import CardSummary
from DriverInfoFile import DriverDetails
from FcoeFile import Fcoe
import SysSummary, utils, ServCapabilities, settings, kvmutils

from UmBoostLib import  SD_system, SD_adapter
logging = settings.get_logger()



def index(req, **param):
	try:
		sid = param['sid']
		ip = param['ip']
		username = param['username']
	except:
		return '-1'
	try:	
		pwd = param['pwd']
	except:
		pwd = ""

	sys_summ = get_sys_summary(sid, ip)
	if sys_summ == -1 or sys_summ == -2:
		return sys_summ
	
	cards_count = sys_summ['cards_count']
	is_licensed = sys_summ['is_licensed']
	
	logging.debug('Menu - cards count: %s , is_licensed : %s',(cards_count,is_licensed))
	
	if cards_count == 0:
		status = generateMenu(sid, ip, username, False, sys_summ, pwd)
	if cards_count >= 1 and not is_licensed:
		status = generateMenu(sid, ip, username, False, sys_summ, pwd)
	if cards_count >= 1 and is_licensed:
		sys_cap = get_sys_capabilities(sid, ip)
		if sys_cap == -1 or sys_cap == -2:
			return sys_cap
		status = generateMenu(sid, ip, username, sys_cap, sys_summ, pwd)
	return status

### get system capabilities 
def get_sys_capabilities(sid, ip):
    obj = ServCapabilities.UmServCapabilities(sid, ip)
    return obj.getCapabilities("text")

### get number of cards, hostname from system summary
def get_sys_summary(sid, ip):
    obj = SysSummary.SysSummary(sid, ip)
    return obj.getsyssummary("dict")

def create_pci_list(sid, ip ,username, pwd, pciloc_list):
	sd_obj = SD_system()
	status = sd_obj.fetch_data(sid, ip ,username, pwd)
	adapter_count = sd_obj.adapter_count
	adap_obj = SD_adapter()

	for i in range(adapter_count):
		sd_obj.get_adapter(i, adap_obj)
		pciloc_list.append(adap_obj.pci_location)


def create_network_menu(doc, networking, pciloc_list, card_list_hash):

	for pci in  pciloc_list:

		if card_list_hash.has_key(pci):
                	card = doc.createElement('card')
	                networking.appendChild(card)

                	card.setAttribute('name',  
					card_list_hash[pci]['cardname'])
	                card.setAttribute('type',  
					card_list_hash[pci]['chiptype'])
        	        card.setAttribute('connector',  
					card_list_hash[pci]['connector'])
                	card.setAttribute('phy_idx', 
					str(card_list_hash[pci]['phy_idx']))
			#card.setAttribute('index', str(cardInfoList['index']))
	                card.setAttribute('serialnumb', 
					str(card_list_hash[pci]['product_serial']))
        	        card.setAttribute('firmwareVersion',
					str(card_list_hash[pci]['firmwareVersion']))
                	card.setAttribute('pciloc', pci)

			for i in range(card_list_hash[pci]['ports_count']):
				i = i+1;
				port = doc.createElement('port')
				card.appendChild(port)
				port.setAttribute('name','Port #%s'%i)

 

def generateMenu(sid, ip, username, capabilities, sys_summ, pwd):
	ostype = utils.get_ostype(sid, ip)
	#Clears the Fcoe cache and returns latest fcoe related details. Ostype check has been removed though it is specifically used for windows.
	refresh_st = utils.refresh_system(sid, ip)
	
	logging.debug('Menu xml Generating')
	xml_filename = '%s%s_menu.xml'%(settings.document_root_path,username)
	
	doc = minidom.parse(xml_filename)
	
	menu = doc.childNodes[0]
	
	# Create the <system> element
	system = doc.createElement("system")
	menu.appendChild(system)
	
	# Set attributes for <system>
	system.setAttribute("name", sys_summ['hostname'])
	system.setAttribute("ostype", str(ostype))
	system.setAttribute("license", str(sys_summ['is_licensed']))
	system.setAttribute("ip", ip )
	system.setAttribute("cardcount", str(sys_summ['cards_count']) )
	system.setAttribute("osname", str(sys_summ['OsName']) )

	if capabilities and capabilities.count('kvm'):
		system.setAttribute("kvm", 'yes' )
		logging.info('Is KVM Enabled - sid : %s, ip : %s'%( sid, ip ))
		kvm_obj = kvmutils.KVMUtils(ip, sid)
		kvm_status = kvm_obj.getKVMStatus()
		logging.info('Is KVM Enabled - status: %s'%( kvm_status ))
		if kvm_status == 255:
		    system.setAttribute("kvm_status", 'yes' )
		else:
		    system.setAttribute("kvm_status", 'no' )
	else:
	    system.setAttribute("kvm", 'no' )
	   
	if capabilities and capabilities.count('hyperv'):
		system.setAttribute("hyperv", 'yes' )
	else:
		system.setAttribute("hyperv", 'no' )
	
	if not int(sys_summ['cards_count']):
		file = open(xml_filename,'w')
		file.write(doc.toprettyxml())
		file.close()
		return None  
	
	#Network Node

	networking = doc.createElement('networking')
	system.appendChild(networking)
	t4_card = False
	bypass_t4_card = False

	card_list_hash={}

	for i in range(int(sys_summ['cards_count'])):
		
		card_obj =  CardSummary(sid,ip,ostype)
		if sys_summ['is_licensed']:
			cardInfoList = card_obj.getMenuCardInfo(i)
			if cardInfoList == -1 or cardInfoList == -2:
				return cardInfoList

			if cardInfoList['chiptype'].lower() == 't4':
				t4_card = True

			bypass_patt = re.compile('^B')
			result = bypass_patt.search(cardInfoList['cardname'])

			if result:
				bypass_t4_card = True

			'''Making the chiptype as t4 to quickly enable webgui to work with the agents having T5 card
				This is a quick fix, must be removed once t5 support is stabilised'''
			if cardInfoList['chiptype'].lower() == 't5':
				cardInfoList['chiptype'] = 'T4'
				t4_card = True

			card_info_hash = {'cardname' :  cardInfoList['cardname'],
					'chiptype' :  cardInfoList['chiptype'],
					'connector' : cardInfoList['connector'],
					'phy_idx'  : cardInfoList['phy_idx'],
					'product_serial' : cardInfoList['product_serial'],
					'firmwareVersion' : cardInfoList['firmwareVersion'],
					'pciloc' : cardInfoList['pciloc'],
					'ports_count' : cardInfoList['ports_count']}

			card_list_hash[cardInfoList['pciloc']] = card_info_hash

			

		else:
			cardInfoList = card_obj.getNLMenuCardInfo(i)
			if cardInfoList == -1 or cardInfoList == -2:
				return cardInfoList
			card = doc.createElement('card')
			networking.appendChild(card)
			card.setAttribute('name', cardInfoList['cardname'])


	pciloc_list=[]
	create_pci_list(sid, ip ,username, pwd, pciloc_list)
	create_network_menu(doc, networking, pciloc_list, card_list_hash)

	if capabilities and capabilities.count('networking'):	
			networkmgm = doc.createElement('networkmgm')
			networking.appendChild(networkmgm)
			networkmgm.setAttribute('name','Network Management')
			if capabilities and capabilities.count('iwarp'):	
				iwarp = doc.createElement('iwarp')
				networking.appendChild(iwarp)
				
	if capabilities and capabilities.count('wdudp'):
		wdudp = doc.createElement('wdudp')
		networking.appendChild(wdudp)
	
	if sys_summ['is_licensed']:
		#Hardware Node
		hardware = doc.createElement('hardware')
		system.appendChild(hardware)
		hardware.setAttribute("name", 'Hardware Features')
	
		if capabilities and capabilities.count('filtering'):
			filtering = doc.createElement('filtering')
			hardware.appendChild(filtering)
			filtering.setAttribute("name", 'Filtering')
		
		if capabilities and capabilities.count('tm'):
			tm = doc.createElement('tm')
			hardware.appendChild(tm)
			tm.setAttribute("name", 'Traffic Management')
			
		if ostype == 2 and t4_card:
			t4Egress = doc.createElement('t4Egress')
			hardware.appendChild(t4Egress)
			t4Egress.setAttribute("name", 'T4 Egress Class Schedulers')
		
		if sys_summ['is_licensed'] and ostype != 3 and ostype != 6:
			boot = doc.createElement('boot')
			hardware.appendChild(boot)
			boot.setAttribute("name", 'Boot')
	
		if sys_summ['is_licensed'] and ostype == 2 and bypass_t4_card:
			bypass = doc.createElement('bypass')
			hardware.appendChild(bypass)
			bypass.setAttribute("name", 'Bypass')
	
	if sys_summ['is_licensed']:
		if ostype == 1 or ostype == 2 or ostype == 3  or ostype == 8:
			#Storage
			storage = doc.createElement('storage')
			system.appendChild(storage)
			storage.setAttribute("name", 'Storage')
	
			if ostype == 1 or ostype == 2  or ostype == 8:
				
				if t4_card:		
					#FCOE
					fcoe = doc.createElement('fcoe')
					storage.appendChild(fcoe)
					fcoe.setAttribute("name", 'FCoE Initiator')
					fcoe.setAttribute("is_fcoe", 'false')
				
				obj = DriverDetails(sid, ip, 'desktop')
				driver_data = obj.is_fcoe_loaded(ostype)
				logging.debug(driver_data)
	            
				if driver_data == -2 or driver_data == -1:
					return driver_data
				elif driver_data == -6:
					driver_data = { 'loaded': -6 }
				else:
					driver_data = simplejson.loads(driver_data)
					
				stop_fcoe_calls = False
				if str(driver_data['loaded']).strip() == '0':
					fcoe.setAttribute("version", driver_data['version'])
					fcoe.setAttribute("is_fcoe", 'true')
					
					fcoe_obj = Fcoe(sid, ip)
					adapter_list_obj = fcoe_obj.list_adapters()
					if adapter_list_obj == -2:
						return adapter_list_obj
					elif adapter_list_obj == -1:
						stop_fcoe_calls = True
						fcoe.setAttribute("is_fcoe", 'false')
					elif len(adapter_list_obj) == 0:
						fcoe_cards_count = len(adapter_list_obj)
						fcoe.setAttribute("cards_count", str(fcoe_cards_count))
						fcoe.setAttribute("lports_count", '0')
						stop_fcoe_calls = True 
					
					if not stop_fcoe_calls:  
						fcoe_cards_count = len(adapter_list_obj)
						fcoe.setAttribute("cards_count", str(fcoe_cards_count))
						
						total_lports = 0
						for i in range(0,fcoe_cards_count):
							#FCOE CARD
							logging.info('-------------FCOE Adapter info')
							logging.info(adapter_list_obj[i].addInfo.Model)
							logging.info(str(adapter_list_obj[i].adapindex))
							logging.info(str(adapter_list_obj[i].addInfo.SerialNumber))
							logging.info('-------------FCOE Adapter info')
							fcard = doc.createElement('fcard')
							fcard.setAttribute("name", adapter_list_obj[i].addInfo.Model)
							fcard.setAttribute("index", str(adapter_list_obj[i].adapindex))
							fcard.setAttribute("serialnumb", str(adapter_list_obj[i].addInfo.SerialNumber))
							fcoe.appendChild(fcard)
							
							local_ports_obj = fcoe_obj.list_local_ports(adapter_list_obj[i].adapName)
							if local_ports_obj == -2 or local_ports_obj == -1:
						  		return local_ports_obj
						  	elif local_ports_obj == 1:
						  		fcard.setAttribute("fcard_lports_count", '0')
								fcard.setAttribute("fcard_firm_ver", str(adapter_list_obj[i].addInfo.FirmwareVersion))
								fcard.setAttribute("fcard_interrupt", str(adapter_list_obj[i].intr_mode_str))
								fcard.setAttribute("fcard_state", str(adapter_list_obj[i].state))
						  		continue
						  	else:
						  		total_lports += len(local_ports_obj)
							
							fcard.setAttribute("fcard_lports_count", str(len(local_ports_obj)))
							fcard.setAttribute("fcard_firm_ver", str(adapter_list_obj[i].addInfo.FirmwareVersion))
							fcard.setAttribute("fcard_interrupt", str(adapter_list_obj[i].intr_mode_str))
							fcard.setAttribute("fcard_state", str(adapter_list_obj[i].state))
							
							for j in range(0,len(local_ports_obj)):
								#FCOE CARD PORTS
								flport = doc.createElement('flport')
								#flport.setAttribute("name", 'FCoE Port #%s[%s]'%(j+1, local_ports_obj[j].PortAttr.PortWWN))
								flport.setAttribute("name", 'FCoE Port #%s'%(j+1))
								fcard.appendChild(flport)
								
								#Port Summary
						  		flport.setAttribute("fport_adpname", str(local_ports_obj[j].adapName))
						  		flport.setAttribute("fport_enode_mac", str(local_ports_obj[j].enode_mac))
						  		
						  		#Port Attributes
						  		flport.setAttribute("fport_state", str(local_ports_obj[j].PortAttr.PortState))
						  		flport.setAttribute("fport_nodewwn", str(local_ports_obj[j].PortAttr.NodeWWN))
						  		flport.setAttribute("fport_portwwn", str(local_ports_obj[j].PortAttr.PortWWN))
						  		
						  		if local_ports_obj[j].mac == '00:00:00:00:00:00':
						  			mac = 'Not Available'
						  		else:
						  			mac = local_ports_obj[j].mac
						  			flport.setAttribute("fport_vlan_id", str(local_ports_obj[j].vlan_id))
							  		flport.setAttribute("fport_fabricname", str(local_ports_obj[j].PortAttr.FabricName))
							  		flport.setAttribute("fport_portfcid", str(local_ports_obj[j].PortAttr.PortFcId))
							  		flport.setAttribute("fport_pscs", str(local_ports_obj[j].PortAttr.PortSupportedClassofService))
							  		flport.setAttribute("fport_osdevice", str(local_ports_obj[j].PortAttr.OSDeviceName))
							  		flport.setAttribute("fport_portspeed", str(local_ports_obj[j].PortAttr.PortSpeed))
							  		flport.setAttribute("fport_portmaxframesize", str(local_ports_obj[j].PortAttr.PortMaxFrameSize))
							  		flport.setAttribute("fport_scsitargetscount", str(local_ports_obj[j].PortAttr.NumberofDiscoveredPorts))
						  		
						  		flport.setAttribute("fport_mac", str(mac))
								
								remote_ports_obj = fcoe_obj.list_remote_ports(adapter_list_obj[i].adapName, local_ports_obj[j].PortAttr.PortWWN)
								
								if remote_ports_obj == -2:
						  			return remote_ports_obj
						  		elif remote_ports_obj == 1:
										continue
						  		
								for k in range(0,len(remote_ports_obj)):
								
									#FCOE SUB PORTS
									frport = doc.createElement('frport')
									#frport.setAttribute("name", 'Remote Port #%s[%s]'%(k+1, remote_ports_obj[k].PortAttr.PortWWN))
									frport.setAttribute("name", 'Remote Port #%s'%(k+1))
									frport.setAttribute("frport_portwwn", str(remote_ports_obj[k].PortAttr.PortWWN))
									flport.appendChild(frport)
									
								#Virtual Ports under Local Ports
								virtual_ports_obj = fcoe_obj.list_vports(adapter_list_obj[i].adapName, local_ports_obj[j].PortAttr.PortWWN)
								
								if virtual_ports_obj == -2:
							  		return virtual_ports_obj
							  	elif virtual_ports_obj == 1:
							  			continue
							  		
								for m in range(0,len(virtual_ports_obj)):
									#FCOE CARD PORTS
									fvport = doc.createElement('fvport')
									#fvport.setAttribute("name", 'Virtual Port #%s[%s]'%(m+1, local_ports_obj[j].PortAttr.PortWWN))
									fvport.setAttribute("name", 'Virtual Port #%s'%(m+1))
									fvport.setAttribute("fvport_portwwn", str(virtual_ports_obj[m].PortAttr.PortWWN))
									flport.appendChild(fvport)
									
									remote_ports_of_vp_obj = fcoe_obj.list_vrports(adapter_list_obj[i].adapName, j, virtual_ports_obj[m].PortAttr.PortWWN)
									
									if remote_ports_of_vp_obj == -2:
							  			return remote_ports_of_vp_obj
							  		elif remote_ports_of_vp_obj == 1:
							  			continue
									
									for n in range(0,len(remote_ports_of_vp_obj)):
									
										#FCOE remote ports of virtual ports
										fvrport = doc.createElement('fvrport')
										#fvrport.setAttribute("name", 'Remote Port #%s[%s]'%(n+1, remote_ports_of_vp_obj[n].PortAttr.PortWWN))
										fvrport.setAttribute("name", 'Remote Port #%s'%(n+1))
										fvrport.setAttribute("fvrport_portwwn", str(remote_ports_of_vp_obj[n].PortAttr.PortWWN))
										fvport.appendChild(fvrport)
										
							fcoe.setAttribute("lports_count", str(total_lports))
				
			if capabilities and capabilities.count('iscsiinitiator'):
				iscsiinitiator = doc.createElement('iscsiinitiator')
				storage.appendChild(iscsiinitiator)
				iscsiinitiator.setAttribute('name','iSCSI Initiator')
				
			if capabilities and capabilities.count('foiscsi'):
				foiscsiinitiator = doc.createElement('foiscsiinitiator')
				storage.appendChild(foiscsiinitiator)
				foiscsiinitiator.setAttribute('name','FO iSCSI Initiator')
			
			if capabilities and capabilities.count('iscsitarget'):
				iscsitarget = doc.createElement('iscsitarget')
				storage.appendChild(iscsitarget)
				
				iscsitarget.setAttribute('name','iSCSI Target')
				
				luns = doc.createElement('luns')
				iscsitarget.appendChild(luns)
				
				luns.setAttribute('name','LUNs')
				
				pg = doc.createElement('pgs')
				iscsitarget.appendChild(pg)
				
				pg.setAttribute('name','Portal groups')
			
				acls = doc.createElement('acls')
				iscsitarget.appendChild(acls)
				
				acls.setAttribute('name','ACLs')
		
	file = open(xml_filename,'w')
	file.write(doc.toprettyxml())
	file.close()

	logging.debug('------Menu xml Generated')

	return '0'
