## Gets the list of Licenses that are in place for user.
##@return
# Returns the html container form of the list of licenses for node.
def index(req, **param):
    ##@var sid
    # The user whose bookmarks are to be given.
    sid = param['sid']
    hostIP = param['hostIP']
    licenseList = getLicenseList(sid,hostIP)
    return licenseList

## Calls the api to fetch the bookmarked hosts for a particular user.
##@param sid
# The session identifier.
##@param hostIP
# The host IP for the node.
##@return 
# Returns a list of the license info list for the host.
def getLicenseList(sid,hostIP):
    import License as lic
    temp =  lic.LicenceInfo(sid,hostIP)
    licenseInfoList = temp.getLicenseInfo()
    return licenseInfoList
