from CardSummary import CardSummary
import logging
import settings
logging.basicConfig(filename=settings.log_path,level=logging.DEBUG)

def index(req, **param):
    try:
        sid = param['sid']
        ip = param['ip']
        index = param['index']
        ostype = param['ostype']
    except:
        return '-1'
    
    if 'pciloc' in param.keys():
    	pciloc = param['pciloc']
    else:
	pciloc =""

    try:
        action = param['action'].strip()
    except:
        action = False

    if action:
        return invokeGetNLCardSummary(sid, ip ,index, ostype, pciloc)
    else:
        cardList = getCardSummary(sid, ip, index, ostype, pciloc)
        
        if cardList == -1 or cardList == -2:
            return cardList
        
        req.content_type = "application/xml"
        return cardList

def getCardSummary(sid,hostIP,index,ostype, pciloc):
    sum_obj =  CardSummary(sid,hostIP,ostype)
    cardInfoList = sum_obj.getCardSummary(index, pciloc)
    return cardInfoList

def invokeGetNLCardSummary(sid,hostIP,index,ostype, pciloc):
    sum_obj =  CardSummary(sid,hostIP,ostype)
    return sum_obj.getNLCardSummary(index, pciloc)
