from NetworkTroubleShootingFile import PingTraceRoute

import logging
import settings
logging.basicConfig(filename=settings.log_path,level=logging.DEBUG)

def index(req, **param):
    data = {}
    
    try:
        data['req_type'] = param['req_type']
    except:
        data['req_type'] = 'desktop'

    try:
        data['sid'] = param['sid']
        data['umip'] =  param['umip']
        data['action'] = param['action']
        data['ip'] = param['ip']
        data['inType'] = 0
    except:
        return '-1'
    
    if data['action'] == 'ping_set':
        data['reqType'] = 1
        data['numpkts'] = param['numpkts']
        data['timeout'] = param['timeout']
        return invoke_ping_traceroute_actions(data)
    
    elif data['action'] == 'ping_result':
        data['reqType'] = 0
        data['numpkts'] = param['numpkts']
        data['timeout'] = param['timeout']
        return invoke_ping_traceroute_actions(data)
    
    elif data['action'] == 'traceroute_initiate':
        data['reqType'] = 3
        
        #Is not required for traceroute
        data['numpkts'] = ''
        data['timeout'] = ''
        return invoke_ping_traceroute_actions(data)

    elif data['action'] == 'traceroute_result':
        #Is not required for traceroute
        return invoke_traceroute_result(data)
    
    return '-1'
    
def invoke_ping_traceroute_actions(data):
    obj = PingTraceRoute(data['sid'],data['umip'])
    status = obj.ping_traceroute_actions(data)
    return status

def invoke_traceroute_result(data):
    obj = PingTraceRoute(data['sid'],data['umip'])
    status = obj.traceroute_result(data)
    return status
