from FcoeFile import Fcoe

import simplejson, settings

def index(req, **kwargs):
    
    try:
        sid = kwargs['sid']
        ip = kwargs['ip']
        adapname = kwargs['adapname']
        action = kwargs['action']
    except:
        return '-1'
    
    if action == 'create':
        try:
            parentWWPN = kwargs['parentWWPN']
            parentWWNN = kwargs['parentWWNN']
            npiVmode = kwargs['npiVmode']
            vPortWWPN = kwargs['vPortWWPN']
            vPortWWNN = kwargs['vPortWWNN']
        except:
            return '-1'
        return invoke_create_npiv(kwargs)
    
    elif action == 'get_vports':
        try:
            flportindex = kwargs['flportindex']
            unique_inc = kwargs['unique_inc']
        except:
            return -1
        return invoke_get_vports(kwargs)
    
    elif action == 'delete_npiv':
        try:
            parentWWNN = kwargs['parentWWNN']
            parentWWPN = kwargs['parentWWPN']
            vportWWNN = kwargs['vportWWNN']
            vportWWPN = kwargs['vportWWPN']
        except:
            return -1
        return invoke_delete_npiv(kwargs)
    
    else:
        return -1
    
def invoke_create_npiv(kwargs):
    npiv_obj =  Fcoe(kwargs['sid'], kwargs['ip'])
    return npiv_obj.create_npiv(kwargs)

def invoke_delete_npiv(kwargs):
    npiv_obj =  Fcoe(kwargs['sid'], kwargs['ip'])
    return npiv_obj.delete_npiv(kwargs)

def invoke_get_vports(kwargs):
    npiv_obj =  Fcoe(kwargs['sid'], kwargs['ip'])
    vports_obj = npiv_obj.list_vports( kwargs['adapname'],  kwargs['flportindex'] )
    ip_id = kwargs['ip'].replace('.','_')
    unique_parent_id = '#fport_content__'+ kwargs['unique_inc'] + '__' + ip_id+ ' .fcoe_port_npiv_mgm_tab'
    
    if vports_obj == -2 or vports_obj == 1:
        return vports_obj
    
    wwpn_arr = []
    wwnn_arr = []
    html = ''
    for i in range(0,len(vports_obj)):
         html += '<li class="vport" onclick="npiv_vport_select(\'%s\', $(this))" >Virtual Port #%s - [ %s ]\
                 <input type="hidden" value="%s" class="vportwwpn" />\
                 <input type="hidden" value="%s" class="vportwwnn" />\
                 </li>'%( unique_parent_id, 
                          i+1, vports_obj[i].PortAttr.PortWWN, 
                          vports_obj[i].PortAttr.PortWWN, vports_obj[i].PortAttr.NodeWWN )
         
         wwpn_str = str(vports_obj[i].PortAttr.PortWWN)
         wwpn_temp = wwpn_str.split(':')
         current_wwpn = wwpn_temp[len(wwpn_temp)-1]
         wwpn_arr.append( current_wwpn )
         
         wwnn_str = str(vports_obj[i].PortAttr.NodeWWN)
         wwnn_temp = wwnn_str.split(':')
         current_wwnn = wwnn_temp[len(wwnn_temp)-1]
         wwnn_arr.append( current_wwnn )
    
    data = {}
    data['current_wwnn'] = ','.join(wwnn_arr)
    data['current_wwpn'] = ','.join(wwpn_arr)
    data['vports_html'] = html
    return simplejson.dumps(data)