import settings, utils
logging = settings.get_logger()
from LinBridgeConfFile import LinBridgeConf

def index(req, **kwargs):
    data = {}
    try:
        data['sid'] = kwargs['sid']
        data['ip'] = kwargs['ip']
        data['action'] = kwargs['action']
        data['type'] = kwargs['type']
    except:
        return '-1'
    
    if data['action'] == 'get':
        return invoke_get_lin_tree(data) 
    elif data['action'] == 'del_bridge':
        try:
            data['brname'] = kwargs['brname']
        except:
            return '-1'
        return invoke_delete_bridge(data)
    elif data['action'] == 'del_vif':
        try:
            data['brname'] = kwargs['brname']
            data['ifname'] = kwargs['ifname']
            data['vmid'] = kwargs['vmid']
        except:
            return '-1'
        return invoke_delete_vif(data) 
    elif data['action'] == 'del_pif':
        try:
            data['brname'] = kwargs['brname']
            data['ifname'] = kwargs['ifname']
        except:
            return '-1'
        return invoke_delete_pif(data)
    elif data['action'] == 'save_bridge_val':
        try:
            data['brname'] = kwargs['brname']
            data['maxAge'] = kwargs['maxAge']
            data['helloTime'] = kwargs['helloTime']
            data['ageingTime'] = kwargs['ageingTime']
            data['forwardDelay'] = kwargs['forwardDelay']
            data['priority'] = ''
            data['stp'] = ''
        except:
            return '-1'
        return invoke_save_bridge_val(data)

def invoke_get_lin_tree(data):
    obj = LinBridgeConf(data['sid'], data['ip'], data['type'])
    return obj.get_lin_tree()

def invoke_delete_bridge(data):
    obj = LinBridgeConf(data['sid'], data['ip'], data['type'])
    return obj.delete_bridge(data['brname'])

def invoke_delete_vif(data):
    obj = LinBridgeConf(data['sid'], data['ip'], data['type'])
    return obj.delete_vif(data)

def invoke_delete_pif(data):
    obj = LinBridgeConf(data['sid'], data['ip'], data['type'])
    return obj.delete_pif(data)

def invoke_save_bridge_val(data):
    obj = LinBridgeConf(data['sid'], data['ip'], data['type'])
    return obj.save_bridge_val(data)