#From Python
import os,shutil

#From project
import settings
from utils import create_user_folder
from StationLogin import StationLogin
logging = settings.get_logger()

def index(req, **kwargs):
    
    data = {}
    
    try:
        data['user'] = kwargs['user']
        data['license_file'] = req.form['license_file_input']
    except:
        return '-1'
    
    data['folder_path'] = '%s%s'%(settings.document_root_path,data['user'])
    data['keyPath'] = settings.get_file_path(data['user'], data['license_file'].filename)
    upload_file(data)
    req.content_type = "application/xml"
    return upload_mgmt_license(data)
    
def upload_mgmt_license(data):
    obj = StationLogin('user','password','sessionId')
    return obj.upload_mgmt_license_key(data)

def upload_file(data):
    
    # Test if the file was uploaded
    if data['license_file'].filename:
        
        #Create an temp empty directory for this user to prevent overwriting of this user files by another user
        dir = data['folder_path'] 
        dir_status = False
        
        if not os.path.exists(dir):
            dir_status = create_user_folder(dir)        
        else:
            shutil.rmtree(dir)
            dir_status = create_user_folder(dir)
        
        dir_path = data['folder_path'] 
        open(os.path.join(dir_path, data['license_file'].filename), 'wb').write(data['license_file'].file.read())
        message = 'The Management License key file "%s" was uploaded successfully in the specified user path by python' % data['license_file'].filename
        logging.info(message)
    else:
        message = 'No file was uploaded'
        logging.info(message)