from IscsiTargetStackGlobalsFile import IscsiTargetStackGlobals

def index(req, **kwargs):
    
    data = {}
    
    try:
        data['sid'] = kwargs['sid']
        data['ip'] = kwargs['ip']
        data['action'] = kwargs['action']
    except:
        return -1
    
    if data['action'] == 'get':
        try:
            data['ostype'] = kwargs['ostype']
        except:
            return -1
        
        try:
            data['type'] = kwargs['type']
        except:
            data['type'] = 'desktop'
        return invoke_get_iscsi_tsg(data)
    elif data['action'] == 'set':
        data['properties_count'] = kwargs['properties_count']
        data['ostype'] = kwargs['ostype']
        return invoke_set_iscsi_tsg(kwargs)

    return -1
    
def invoke_get_iscsi_tsg(data):
    obj =  IscsiTargetStackGlobals(data['sid'], data['ip'])
    return obj.get_iscsi_tsg(data['ostype'], data['type'])

def invoke_set_iscsi_tsg(data):
    obj =  IscsiTargetStackGlobals(data['sid'], data['ip'])
    return obj.set_iscsi_tsg(data)