from IscsiTargetPropertiesFile import IscsiTargetProperties

def index(req, **kwargs):
    
    data = {}
    
    try:
        data['sid'] = kwargs['sid']
        data['ip'] = kwargs['ip']
        data['action'] = kwargs['action']
    except:
        return -1
    
    if data['action'] == 'get_targets':
        try:
            data['type'] = kwargs['type']
        except:
            data['type'] = 'desktop'
        return invoke_get_get_targets(data)
    
    elif data['action'] == 'get_properties':
        try:
            data['index'] = kwargs['index']
            data['ostype'] = kwargs['ostype']
        except:
            return -1
        
        try:
            data['type'] = kwargs['type']
        except:
            data['type'] = 'desktop'
        
        return invoke_get_properties(data)
    
    elif data['action'] == 'start' or data['action'] == 'stop' or data['action'] == 'delete':
        try:
            data['index'] = kwargs['index']
        except:
            return -1
        return invoke_update_target_status(data)
    
    elif data['action'] == 'set':
        try:
            data['index'] = kwargs['index']
            data['properties_count'] = kwargs['properties_count']
            data['ostype'] = kwargs['ostype']
        except:
            return -1
        return invoke_set_target_props(kwargs)

    return -1
    
def invoke_get_get_targets(data):
    obj =  IscsiTargetProperties(data['sid'], data['ip'])
    return obj.get_targets(data)

def invoke_get_properties(data):
    obj =  IscsiTargetProperties(data['sid'], data['ip'])
    return obj.get_properties(data['index'], data['ostype'], data['type'])

def invoke_update_target_status(data):
    obj =  IscsiTargetProperties(data['sid'], data['ip'])
    return obj.update_target_status(data['index'], data['action'])

def invoke_set_target_props(data):
    obj =  IscsiTargetProperties(data['sid'], data['ip'])
    return obj.set_target_props(data)
