from IscsiTargetPgUpdateFile import IscsiTargetPgUpdate

def index(req, **kwargs):
    
    data = {}
    
    try:
        data['sid'] = kwargs['sid']
        data['ip'] = kwargs['ip']
        data['action'] = kwargs['action']
    except:
        return -1
    
    try:
        data['req_type'] = kwargs['req_type']
    except:
        data['req_type'] = 'desktop'
    
    if data['action'] == 'get_targets':
        return invoke_get_targets(data)
    
    elif data['action'] == 'get_portals':
        try:
            data['index'] = kwargs['index']
            data['ostype'] = kwargs['ostype']
        except:
            return -1
        return invoke_get_pg_list(data)
    
    elif data['action'] == 'save_order':
        try:
            data['index'] = kwargs['index']
            data['pgnamestr'] = kwargs['pgnamestr']
        except:
            return -1
        return invoke_set_pglist_order(data)
    
    elif data['action'] == 'delete_pg':
        try:
            data['index'] = kwargs['index']
            data['pgnamestr'] = kwargs['pgnamestr']
        except:
            return -1
        return invoke_delete_pg(data)
    
    return -1
    
def invoke_get_targets(data):
    obj =  IscsiTargetPgUpdate(data['sid'], data['ip'])
    return obj.get_targets(data)

def invoke_get_pg_list(data):
    obj =  IscsiTargetPgUpdate(data['sid'], data['ip'])
    return obj.get_pg_list(data['index'], data['ostype'], data['req_type'])

def invoke_set_pglist_order(data):
    obj =  IscsiTargetPgUpdate(data['sid'], data['ip'])
    return obj.set_pglist_order(data['index'], data['pgnamestr'])

def invoke_delete_pg(data):
    obj =  IscsiTargetPgUpdate(data['sid'], data['ip'])
    return obj.delete_pg(data['index'], data['pgnamestr'])