from IscsiTargetAddLunFile import IscsiTargetAddLun
import simplejson

def index(req, **kwargs):
    
    data = {}
    
    try:
        data['sid'] = kwargs['sid']
        data['ip'] = kwargs['ip']
        data['action'] = kwargs['action']
    except:
        return -1
    
    if data['action'] == 'initial':
        try:
           data['ostype'] = kwargs['ostype']
        except:
           return -1
        return invoke_get_intial_data(data)

    elif data['action'] == 'save':
        try:
            data['index'] = kwargs['index']
            data['lun_string'] = kwargs['lun_string']
        except:
            return -1
        return invoke_save_lun(data)
    elif data['action'] == 'get_next_ramdisk':
        try:
            data['index'] = kwargs['index']
            data['ostype'] = kwargs['ostype']
        except:
            return -1
        return invoke_get_next_ramdisk(data)
    
    return -1
    
def invoke_get_intial_data(data):
    obj = IscsiTargetAddLun(data['sid'], data['ip'])
    returned_data = {}
    returned_data['targets_list'] = obj.get_targets_list(data)
    returned_data['devices_list'] = obj.get_devices(data['ostype'])
    return simplejson.dumps(returned_data)

def invoke_save_lun(data):
    obj = IscsiTargetAddLun(data['sid'], data['ip'])
    return obj.add_lun(data['index'], data['lun_string'])

def invoke_get_next_ramdisk(data):
    obj = IscsiTargetAddLun(data['sid'], data['ip'])
    return obj.get_next_ramdisk(data['index'], data['ostype'])