from IscsiInitiatorTargetsFile import IscsiInitiatorTargets
import settings, simplejson
logging = settings.get_logger()

def index(req, **kwargs):
    
    data = {}
    
    try:
        data['req_type'] = kwargs['req_type']
    except:
        data['req_type'] = 'desktop'
    
    try:
        data['sid'] = kwargs['sid']
        data['ip'] = kwargs['ip']
        data['action'] = kwargs['action']
    except:
        return -1
    
    if data['action'] == 'get_initiators':
        try:
            data['ostype'] = kwargs['ostype']
        except:
            return -1
        return invoke_get_initiators(data)
    
    elif data['action'] == 'get_targets':
        try:
            data['ostype'] = kwargs['ostype']
        except:
            return -1
        return invoke_get_targets(data)
    
    elif data['action'] == 'delete_targets':
        try:
            data['stack'] = kwargs['stack']
            data['tarname'] = kwargs['tarname']
            data['portal'] = kwargs['portal']
            data['perflag'] = kwargs['perflag']
            data['iniIP'] = kwargs['iniIP']
            data['index'] = kwargs['index']
        except:
            return -1
        return invoke_delete_targets(data)
    
    elif data['action'] == 'get_session':
        try:
            data['stack'] = kwargs['stack']
            data['ostype'] = kwargs['ostype']
        except:
            return -1
        return invoke_get_session(data)
    
    elif data['action'] == 'get_connections':
        try:
            data['stack'] = kwargs['stack']
            data['sessid'] = kwargs['sessid']
            data['iniName'] = kwargs['iniName']
            data['tarName'] = kwargs['tarName']
            data['ostype'] = kwargs['ostype']
        except:
            return -1
        return invoke_get_connections(data)
    
    elif data['action'] == 'login':
        
        try:
            data['stack'] = kwargs['stack']
            data['tarname'] = kwargs['tarname']
            data['portal'] = kwargs['portal']
            data['persists'] = kwargs['persists']
            data['iniIP'] = kwargs['iniIP']
            data['mpio'] = kwargs['mpio']
            data['auth'] = kwargs['auth']
            data['IniChapUser'] = kwargs['IniChapUser']
            data['IniChapPass'] = kwargs['IniChapPass']
            data['TargetChapUser'] = kwargs['TargetChapUser']
            data['TargetChapPass'] = kwargs['TargetChapPass']
            data['hdigest'] = kwargs['hdigest']
            data['ddigest'] = kwargs['ddigest']
            data['intiator_index'] = kwargs['intiator_index']
        except:
            return -1    
        
        return invoke_login(data)
    
    elif data['action'] == 'session_logout':
        try:
            data['stack'] = kwargs['stack']
            data['sessid'] = kwargs['sessid']
            data['index'] = kwargs['index']
        except:
            return -1
        return invoke_session_logout(data)
    
    elif data['action'] == 'logout':
        try:
            data['stack'] = kwargs['stack']
            data['sessid'] = kwargs['sessid']
            data['sessid_count'] = kwargs['sessid_count']
            data['index'] = kwargs['index']
        except:
            return -1
        return invoke_logout(data)
    
    elif data['action'] == 'get_disks':
        try:
            data['stack'] = kwargs['stack']
            data['sessid'] = kwargs['sessid']
            data['ostype'] = kwargs['ostype']
        except:
            return -1
        return invoke_get_disks(data)
    
    elif data['action'] == 'get_ip':
        try:
            data['stack'] = kwargs['stack']
            data['index'] = kwargs['index']
        except:
            return -1
        return invoke_get_iplist(data)
    
    elif data['action'] == 'delete_con':
        try:
            data['stack'] = kwargs['stack']
            data['index'] = kwargs['index']
            data['sessid'] = kwargs['sessid']
            data['cid'] = kwargs['cid']
        except:
            return -1
        return invoke_delete_connection(data)
    
    elif data['action'] == 'add_con':
        try:
            data['stack'] = kwargs['stack']
            data['index'] = kwargs['index']
            data['sessid'] = kwargs['sessid']
            data['initIP'] = kwargs['initIP']
            data['tarPortal'] = kwargs['tarPortal']
        except:
            return -1
        return invoke_add_connection(data)
    

def invoke_get_targets(data):
    obj =  IscsiInitiatorTargets( data['sid'], data['ip'], data['req_type'] )
    if data['ostype'] == '1':
        #Expected values are -1 Failed, -2 Session timeout, 1 skip error or html
        data1 = obj.get_targets( '23', '1' )
        data2 = obj.get_targets( '24', '1' )
        data3 = obj.get_targets( '27', '1' )
        data1_targets = data1
        data2_targets = data2
        data3_targets = data3
        if data1 == -2 or data2 == -2 or data3 == -2:
            return -2
        elif data1 == -1 and data2 == -1 and data3 == -1:
            return -1
        else:
            new_data = {}
            if data1 == 1 or data1 == -1:
                data1_targets = ''
                                        
            if data2 == 1 or data2 == -1:
                data2_targets = ''
                
            if data3 == 1 or data3 == -1:
                data3_targets = ''
            
            return data1_targets + data2_targets + data3_targets
    elif data['ostype'] == '2':
        return obj.get_targets( '22', '2' )
    elif data['ostype'] == '3':
        return obj.get_targets( '26', '3' )

def invoke_delete_targets(data):
    obj =  IscsiInitiatorTargets( data['sid'], data['ip'], data['req_type'] )
    return obj.delete_targets( data )

def invoke_get_session(data):
    obj =  IscsiInitiatorTargets( data['sid'], data['ip'], data['req_type'] )
    return obj.get_session( data['stack'], data['ostype'] )

def invoke_get_connections(data):
    obj =  IscsiInitiatorTargets( data['sid'], data['ip'], data['req_type'] )
    return obj.get_connections( data )

def invoke_login(data):
    obj =  IscsiInitiatorTargets( data['sid'], data['ip'], data['req_type'] )
    return obj.login( data )

def invoke_logout(data):
    obj =  IscsiInitiatorTargets( data['sid'], data['ip'], data['req_type'] )
    return obj.logout( data )

def invoke_session_logout(data):
    obj =  IscsiInitiatorTargets( data['sid'], data['ip'], data['req_type'] )
    return obj.session_logout( data['stack'], data['sessid'], data['index'] )

def invoke_get_disks(data):
    obj =  IscsiInitiatorTargets( data['sid'], data['ip'], data['req_type'] )
    return obj.get_disks( data['stack'], data['sessid'], data['ostype'] )

def invoke_get_iplist(data):
    obj =  IscsiInitiatorTargets(data['sid'], data['ip'], data['req_type'])
    return obj.get_iplist( data['stack'], data['index'] )

def invoke_delete_connection(data):
    obj =  IscsiInitiatorTargets(data['sid'], data['ip'], data['req_type'])
    return obj.delete_connection( data )

def invoke_add_connection(data):
    obj =  IscsiInitiatorTargets(data['sid'], data['ip'], data['req_type'])
    return obj.add_connection( data )

def invoke_get_initiators(data):
    obj =  IscsiInitiatorTargets(data['sid'], data['ip'], data['req_type'])
    if data['ostype'] == '1':
        #Expected values are -1 Failed, -2 Session timeout, 1 skip error or data dict
        data1 = obj.get_initiators( '23', '1')
        data2 = obj.get_initiators( '24', '1' )
        data3 = obj.get_initiators( '27', '1' )
        data1_dict = {}
        data2_dict = {}
        data3_dict = {}
        
        if data1 == -2 or data2 == -2 or data3 == -2:
            return -2
        elif data1 == -1 and data2 == -1 and data3 == -1:
            return -1
        else:
            if data1 == 1 or data1 == -1:
                data1_dict['select_html'] = ''
                data1_dict['stack_html'] = ''
            else:
                data1_dict['select_html'] = data1['select_html']
                data1_dict['stack_html'] = data1['stack_html']
                                        
            if data2 == 1 or data2 == -1:
                data2_dict['select_html'] = ''
                data2_dict['stack_html'] = ''
            else:
                data2_dict['select_html'] = data2['select_html']
                data2_dict['stack_html'] = data2['stack_html']
                
            if data3 == 1 or data3 == -1:
                data3_dict['select_html'] = ''
                data3_dict['stack_html'] = ''
            else:
                data3_dict['select_html'] = data3['select_html']
                data3_dict['stack_html'] = data3['stack_html']
                
            return_data = {}
            
            unique_parent_id = '#iscsi_initiator_content__incend__%s .iscsi_initiator_targets_tab'%( data['ip'].replace('.','_') )
            fn = "i_t_initiator_change('%s', '%s', $(this), '%s')"%( unique_parent_id, data['ip'], data['ostype'] )
            html = '<select class = "i_in_t_initiator_list" onchange="%s" ><option value="" >Select One..</option>'%( fn )
            
            return_data['select_html'] = html + data1_dict['select_html'] + data2_dict['select_html'] + data3_dict['select_html'] + '</select>'
            logging.info(data1_dict['stack_html'])
            logging.info(data2_dict['stack_html'])
            logging.info(data3_dict['stack_html'])
            return_data['stack_html'] = data1_dict['stack_html'] +'__23#'+ data2_dict['stack_html'] +'__24#'+ data3_dict['stack_html'] +'__27'
            return simplejson.dumps(return_data)
    elif data['ostype'] == '2':
        return obj.get_initiators( '22', '2' )
    elif data['ostype'] == '3':
        return obj.get_initiators( '26', '3' )