from IscsiInitiatorNodesFile import IscsiInitiatorNodes

def index(req, **kwargs):
    
    data = {}
    
    try:
        data['sid'] = kwargs['sid']
        data['ip'] = kwargs['ip']
        data['action'] = kwargs['action']
    except:
        return -1
    
    if data['action'] == 'get_initiators':
        try:
            data['ostype'] = kwargs['ostype']
        except:
            return -1
        
        try:
            data['type'] = kwargs['type']
        except:
            data['type'] = 'desktop'
        
        return invoke_get_initiators(data)
    
    elif data['action'] == 'update_initiator':
        try:
            data['stack'] = kwargs['stack']
            data['index'] = kwargs['index']
            data['action'] = kwargs['update_type']
        except:
            return -1
        return invoke_update_initiator(data)
    
    elif data['action'] == 'get_properties':
        try:
            data['stack'] = kwargs['stack']
            data['index'] = kwargs['index']
            data['ostype'] = kwargs['ostype']
        except:
            return -1
        
        try:
            data['type'] = kwargs['type']
        except:
            data['type'] = 'desktop'
        
        return invoke_get_initiator_properties(data)
    
    elif data['action'] == 'set_properties':
        try:
            data['properties_count'] = kwargs['properties_count']
            data['index'] = kwargs['index']
            data['stack'] = kwargs['stack']
            data['ostype'] = kwargs['ostype']
        except:
            return -1
        return invoke_set_initiator_properties(kwargs)
    
    elif data['action'] == 'add_iqn':
        try:
            data['stack'] = kwargs['stack']
            data['nodename'] = kwargs['nodename']
        except:
            return -1
        return invoke_add_iqn(kwargs)
    
def invoke_get_initiators(data):
    obj =  IscsiInitiatorNodes(data['sid'], data['ip'])
    return obj.get_initiators( data['ostype'], data['type'] )

def invoke_update_initiator(data):
    obj =  IscsiInitiatorNodes(data['sid'], data['ip'])
    return obj.update_initiator( data['stack'], data['index'], data['action'] )

def invoke_get_initiator_properties(data):
    obj =  IscsiInitiatorNodes(data['sid'], data['ip'])
    return obj.get_initiator_properties( data['stack'], data['index'], data['ostype'], data['type'] )

def invoke_set_initiator_properties(data):
    obj =  IscsiInitiatorNodes(data['sid'], data['ip'])
    return obj.set_initiator_properties( data )

def invoke_add_iqn(data):
    obj =  IscsiInitiatorNodes( data['sid'], data['ip'] )
    return obj.add_iqn( data['stack'], data['nodename'] )
