from IscsiInitiatorDiscoverTargetsFile import IscsiInitiatorDiscoverTargets
import simplejson

def index(req, **kwargs):
    
    data = {}
    
    try:
        data['sid'] = kwargs['sid']
        data['ip'] = kwargs['ip']
        data['action'] = kwargs['action']
    except:
        return -1
    
    try:
        data['req_type'] = kwargs['req_type']
    except:
        data['req_type'] = 'desktop'
    
    if data['action'] == 'get_targets':
        try:
            data['ostype'] = kwargs['ostype']
        except:
            return -1
        return invoke_get_targets(data)
    
    elif data['action'] == 'discover_targets':
        try:
            data['ostype'] = kwargs['ostype']
            data['stack'] = kwargs['stack']
            data['portal'] = kwargs['portal']
            data['initIp'] = kwargs['initIp']
            data['initiator_index'] = kwargs['initiator_index']
        except:
            return -1
        return invoke_discover_targets(data)
    
    elif data['action'] == 'delete_targets':
        try:
            data['stack'] = kwargs['stack']
            data['portal'] = kwargs['portal']
            data['index'] = kwargs['index']
        except:
            return -1
        return invoke_delete_targets(data)
    
    elif data['action'] == 'get_nodes':
        try:
            data['stack'] = kwargs['stack']
        except:
            return -1
        return invoke_get_nodes(data)
    
    elif data['action'] == 'get_ip':
        try:
            data['stack'] = kwargs['stack']
            data['index'] = kwargs['index']
        except:
            return -1
        return invoke_get_iplist(data)
    
def invoke_discover_targets(data):
    obj =  IscsiInitiatorDiscoverTargets( data['sid'], data['ip'], data['req_type'] )
    return obj.discover_targets( data['stack'], data['portal'], data['initIp'], data['initiator_index'], data['ostype'] )

def invoke_get_targets(data):
    obj =  IscsiInitiatorDiscoverTargets( data['sid'], data['ip'] , data['req_type'] )
    if data['ostype'] == '1':
        data1 = obj.get_targets( '23', '1' )
        data2 = obj.get_targets( '24', '1' )
        data3 = obj.get_targets( '27', '1' )
        
        #Show nodes of stack 23 by default
        data['stack'] = '23'
        nodes_html = invoke_get_nodes(data)
        
        if data1 == -2 or data2 == -2 or data3 == -2:
            return -2
        elif data1 == -1 and data2 == -1 or data3 == -1:
            return -1
        else:
            new_data = {}
            if data1 == 1 or data1 == -1:
                data1_targets = ''
                data1_portals = ''
            else:
                data1_targets = data1['targets_html']
                data1_portals = data1['portals_html']
                
            if data2 == 1 or data2 == -1:
                data2_targets = ''
                data2_portals = ''
            else:
                data2_targets = data2['targets_html']
                data2_portals = data2['portals_html']
                
            if data3 == 1 or data3 == -1:
                data3_targets = ''
                data3_portals = ''
            else:
                data3_targets = data3['targets_html']
                data3_portals = data3['portals_html']
                
            new_data['targets_html'] = data1_targets + data2_targets + data3_targets
            new_data['portals_html'] = data1_portals + data2_portals + data3_portals
            new_data['nodes_html'] = nodes_html
            return simplejson.dumps(new_data)
    elif data['ostype'] == '2':
        return simplejson.dumps(obj.get_targets( '22', '2' ))
    elif data['ostype'] == '3':
        return simplejson.dumps(obj.get_targets( '26', '3' ))

def invoke_delete_targets(data):
    obj =  IscsiInitiatorDiscoverTargets( data['sid'], data['ip'] , data['req_type'] )
    return obj.delete_targets( data['stack'], data['portal'], data['index'] )

def invoke_get_nodes(data):
    obj =  IscsiInitiatorDiscoverTargets(data['sid'], data['ip'] , data['req_type'])
    return obj.get_nodes( data['stack'], False )

def invoke_get_iplist(data):
    obj =  IscsiInitiatorDiscoverTargets(data['sid'], data['ip'] , data['req_type'])
    return obj.get_iplist( data['stack'], data['index'] )
