import SysSummary, logging, settings, os
logging.basicConfig(filename=settings.log_path, level=logging.DEBUG)

def index(req, **param):

    try:
        sid = param['sid']
        ip = param['ip']
        index = param['index']
        username = param['user']
        action = param['action']
    except:
        return '-1'
    
    if action == 'copy':
        status = get_info_file(sid, ip, index ,username)
        if status == 0:
            chinfofile_path = settings.get_chinfofile_path(username, ip)
            if not os.path.exists(chinfofile_path):
                return -1
        return status
            
    else:
        req.headers_out["Content-type"] = "application/force-download"
        req.headers_out["Content-Disposition"] = "attachment; filename=chinfofile"
        req.content_type = "application/x-file-to-save"
        chinfofile_path = settings.get_chinfofile_path(username, ip)
        fp = open(chinfofile_path)
        content = fp.read()
        fp.close()
        return content
    
def get_info_file(sid, ip,index, username):
    obj = SysSummary.SysSummary( sid, ip )
    return obj.get_card_info_file(index , username)    
