from FoiscsiInitiatorPortsFile import FoiscsiInitiatorPorts

import settings
logging = settings.get_logger()

def index(req, **kwargs):
    
    data = {}
    try:
        data['req_type'] = kwargs['req_type']
        data['sid'] = kwargs['sid']
        data['ip'] = kwargs['ip']
        data['action'] = kwargs['action']
    except:
        return '-1'
    
    if data['action'] == 'get':
        try:
            data['devno'] = kwargs['devno']
            data['ifid'] = kwargs['ifid']
        except:
            return '-1'
        return invoke_get_initial_data(data)
    
    elif data['action'] == 'get_ifconfig_values':
        try:
            data['devno'] = kwargs['devno']
            data['ifid'] = kwargs['ifid']
            data['ntype'] = kwargs['ntype']
        except:
            return '-1'
        return invoke_get_ifconfig_values(data)
    
    elif data['action'] == 'set':
        try:
            data['devno'] = kwargs['devno']
            data['ifid'] = kwargs['ifid']
            data['ntype'] = kwargs['ntype']
            data['vlan'] = kwargs['vlan']
            data['mtu'] = kwargs['mtu']
            data['sip'] = kwargs['sip']
            data['mask'] = kwargs['mask']
            data['gw'] = kwargs['gw']
            data['setboth_flag'] = kwargs['setboth_flag']
        except:
            return -1
        return invoke_set_values(data)
        
    elif data['action'] == 'up':
        try:
            data['devno'] = kwargs['devno']
            data['ifid'] = kwargs['ifid']
        except:
            return -1
        return invoke_port_updown(data)
    
    elif data['action'] == 'down':
        try:
            data['devno'] = kwargs['devno']
            data['ifid'] = kwargs['ifid']
        except:
            return -1
        return invoke_port_updown(data)
    
    elif data['action'] == 'clear':
        try:
            data['devno'] = kwargs['devno']
            data['ifid'] = kwargs['ifid']
            data['ntype'] = kwargs['ntype']
        except:
            return -1
        return invoke_clear(data)
    
def invoke_get_initial_data(data):
    obj =  FoiscsiInitiatorPorts( sid = data['sid'], ip = data['ip'], req_type = data['req_type'])
    return obj.get_initial_data(data)

def invoke_get_ifconfig_values(data):
    obj =  FoiscsiInitiatorPorts( sid = data['sid'], ip = data['ip'], req_type = data['req_type'])
    return obj.get_ifconfig_values(data)

def invoke_set_values(data):
    obj =  FoiscsiInitiatorPorts( sid = data['sid'], ip = data['ip'], req_type = data['req_type'])
    return obj.set_values(data)

def invoke_port_updown(data):
    obj =  FoiscsiInitiatorPorts( sid = data['sid'], ip = data['ip'], req_type = data['req_type'])
    return obj.port_updown(data)

def invoke_clear(data):
    obj =  FoiscsiInitiatorPorts( sid = data['sid'], ip = data['ip'], req_type = data['req_type'])
    return obj.clear_ip(data)