from FilteringFile import Filter
from CardSummary import CardSummary
from PortSummary import PortsSummary

import logging
import settings
logging.basicConfig(filename=settings.log_path,level=logging.DEBUG)

def index(req, **kwargs):
    
    data = {}
    
    try:
        data['action'] = kwargs['action']
        data['sid'] = kwargs['sid']
        data['ip'] = kwargs['ip']
        data['ostype'] = kwargs['ostype']
        data['card_index'] = kwargs['card_index']
    except:
        return -1
    
    try:
        data['pciloc'] = kwargs['pciloc']
    except:
        data['pciloc'] = get_pciloc(data, data['ostype'])

    if data['pciloc'] == -1 or data['pciloc'] == -2:
        return data['pciloc']
    
    try:
        data['ifName'] = kwargs['ifname']
    except:
        data['ifName'] = get_ifname(data)
        
    if data['ifName'] == -1 or data['ifName'] == -2:
        return data['ifName']
    
    if data['action'] == 'get':
        
        data['maxFils'] = 0
        data['reqType'] = 0 
        
        return invoke_get_set_filter_value(data)
    
    elif data['action'] == 'set':
        
        try:
            data['maxFils'] = kwargs['maxfilter']
        except:
            return -1
        
        data['reqType'] = 1
        
        return invoke_get_set_filter_value(data)
    
    elif data['action'] == 'set_properties':
        
        try:
            data['filter_count'] = kwargs['filter_count']
            data['fid'] = kwargs['fid']
            action_type = kwargs['action_type']
        except:
            return -1
        
        return invoke_set_filter_properties(kwargs)
    
    elif data['action'] == 'delete':
        
        try:
            data['ifname'] = kwargs['ifname']
            data['fid'] = kwargs['fid']
            data['fid_count'] = kwargs['fid_count']
        except:
            return -1
        
        return invoke_delete_filter(kwargs)
    
    return -1
        

def invoke_get_set_filter_value(data):
    obj =  Filter(data['sid'], data['ip'])
    return obj.get_set_filter_value(data)

def get_pciloc(data, ostype):
    card_obj =  CardSummary(data['sid'], data['ip'], ostype)
    return card_obj.get_pciloc(data['card_index'])

def get_ifname(data):
    port_obj =  PortsSummary(data['sid'], data['ip'], data['pciloc'], 1, 'desktop', data['ostype'])
    return port_obj.get_port_ifname()

def invoke_set_filter_properties(data):
    obj =  Filter(data['sid'], data['ip'])
    return obj.set_filter_properties(data)

def invoke_delete_filter(data):
    obj =  Filter(data['sid'], data['ip'])
    return obj.delete_filter(data)