#From project
from ConfigFlashFile import ConfigFlash
import settings

#from Python
import os
logging = settings.get_logger()

def index(req, **kwargs):
    
    data = {}
    
    try:
        data['ip'] = kwargs['ip']
        data['sid'] = kwargs['sid']
        data['req_type'] = kwargs['req_type']
        action = kwargs['action']
    except:
        return '-1'
    
    if action == 'get_status':
        try:
            data['index'] = kwargs['index']
        except:
            return '-1'
        return invoke_getconfig_file_type(data)
        
    elif action == 'upload':
        
        try:
            data['username'] = kwargs['user']
            data['name'] = kwargs['name']
            data['cardindex'] = kwargs['cardindex']
            data['config_file'] = req.form[data['name']]
        except:
            return '-1'
        
        data['fname'] = 'configfile_%s_%s'%(data['ip'].replace('.','_'), data['config_file'].filename)
        upload_file(data)
        
        req.content_type = "application/xml"
        return upload_config(data)
    
def upload_config(data):
    config_obj = ConfigFlash(data['sid'], data['ip'], data['req_type'])
    return config_obj.flashConfig(data)

def upload_file(data):
    
    # Test if the file was uploaded
    if data['config_file'].filename:
        # build absolute path to files directory
        dir_path = '%s%s'%(settings.document_root_path,data['username'])
        open(os.path.join(dir_path, data['fname']), 'wb').write(data['config_file'].file.read())
        message = 'The Config file "%s" was uploaded successfully in the specified user path by python' % data['fname']
        logging.info(message)
    else:
        message = 'No file was uploaded'
        logging.info(message)
        
def invoke_getconfig_file_type(data):
    config_obj = ConfigFlash(data['sid'], data['ip'], data['req_type'])
    return config_obj.getconfig_file_type(data['index'])