from BulkNetworkConfFile import BulkNetworkConf

import os, settings
logging = settings.get_logger()

def index(req, **kwargs):
    data = {}
    
    try:
        data['sid'] = kwargs['sid']
        action = kwargs['action']
        data['req_type'] = kwargs['req_type']
    except:
        return -1
    
    if action == 'get_initial_data':
        return invoke_get_initial_data(data)
   
    elif action == 'save_nw_conf':
        try:
            data['group_name'] = kwargs['group_name']
            data['mtu'] = kwargs['mtu']
            data['vlan'] = kwargs['vlan']
            data['action_type'] = kwargs['action_type']
        except:
            return -1
        return invoke_save_nw_conf(data)
    
    return '-1'

def invoke_get_initial_data(data):
    obj = BulkNetworkConf(data['sid'], data['req_type'])
    return obj.get_initial_data(data)

def invoke_save_nw_conf(data):
    obj = BulkNetworkConf(data['sid'], data['req_type'])
    return obj.save_nw_conf(data)