#!/usr/bin/python
import os, getopt, sys, simplejson, settings

#Constants
FILENAME = settings.BLK_PWD_FILE
COMMON_CMD = settings.CLI_CMD

def main(argv):
    
    if len(argv) == 1:
        print '\nError: Incorrect number of arguments'
        print '\nUsage: python bulk_get_data.py -i 10.193.185.104 -u root -p redhat\n'
        sys.exit(2)
    else:
        argv = argv[1:]

    result = ['\nAdapter information:\n']
    ip = ''
    username = ''
    pwd = ''
    type = 'string'
    
    try:
        opts, args = getopt.getopt(argv,"i:u:p:t:",["ipaddress=","username=","password="])
    except getopt.GetoptError:
        print '\nError: Incorrect number of arguments'
        print '\nUsage: python bulk_get_data.py -i 10.193.185.104 -u root -p redhat\n'
        sys.exit(2)
    
    correct_opt_count = 0
    for opt, arg in opts:
        if opt == '-i':
            ip = arg.strip()
            correct_opt_count += 1
        elif opt == '-u':
            username = arg.strip()
            correct_opt_count += 1
        elif opt == '-p':
            pwd = arg.strip()
            correct_opt_count += 1
        elif opt == '-t':
            type = arg.strip()
    
    if correct_opt_count != 3:
        print '\nError: Incorrect number of arguments'
        print '\nUsage: python bulk_get_data.py -i 10.193.185.104 -u root -p redhat\n'
        sys.exit()
    
    if type == 'json':
        #Default success
        json_dict = {'status' : '0'}
    #Saving password to the file
    f_open = False
    try:
        fp = open(FILENAME,'a+')
        content = fp.read()
        f_open = True
        fp.close()
        f_open = False
        entry = '%s %s\n'%( ip, pwd )
        if ip not in content:
            fp = open(FILENAME,'r+b')
            fp.write(entry)
            fp.close()
        else:
            removeLine( FILENAME, ip, entry )
    except IOError, e:
        if f_open:
            fp.close()
        if type == 'json':
            json_dict['status'] = '-1'
            print simplejson.dumps(json_dict)
        else:
            print 'ERROR: Unable to open the required files'
        sys.exit()
    
    cmd  = "%s -h %s -u %s chelsio ListAdapters"%(COMMON_CMD, ip, username )
    cmd_result = runCMD(cmd, type)
    
    try:
        cmd_result = cmd_result.split('Adapter information:')[1]
    except:
        if type == 'json':
            json_dict['status'] = '-1'
            print simplejson.dumps(json_dict)
        else:
            print '\nError:\n'
            print cmd_result
        sys.exit()
    
    no_of_cards = cmd_result.count('Adapter #')
    if no_of_cards:
        content_list = filter(None, cmd_result.split('\n\n'))
        if type == 'json':
            json_dict['no_of_cards'] = no_of_cards
        for i in content_list:
            #Adapter
            idx = i.find('Adpater #')
            adapter_no = i[idx+15].strip()
            result.append("Adpater #\t\t\t: %s"%adapter_no)

            #Model
            idx = i.find('Model')
            slice_str = i[idx+10:]
            model = slice_str.split('\n')[0].strip()
            result.append("Model \t\t\t\t: %s"%model)
            if type == 'json':
                json_dict['model_adapter_%s'%(adapter_no)] = model
            
            #PCI Location
            idx = i.find('PCI Location')
            slice_str = i[idx+17:]
            pci = slice_str.split('\n')[0].strip()
            result.append("PCI Location \t\t\t: %s"%pci)
            if type == 'json':
                json_dict['pci_adapter_%s'%(adapter_no)] = pci
            
            cmd  = "%s -h %s -u %s chelsio ListPorts pci=%s"%(COMMON_CMD, ip, username, pci)
            cmd_result = runCMD(cmd, type)
            no_of_ports = cmd_result.count('Port Instance')
            
            if no_of_ports:
                result.append("No. of ports \t\t\t: %s"%no_of_ports)
                if type == 'json':
                    json_dict['no_of_ports_adapter_%s'%(adapter_no)] = no_of_ports
                temp_list = cmd_result.split('\n\n')
                content_list = temp_list[0:len(temp_list)-2]
                ifnames = []
                for i in content_list:
                    #Ifnames
                    idx = i.find('Friendly Name')
                    slice_str = i[idx+28:]
                    ifname = slice_str.split('\n')[0].strip()
                    ifnames.append(ifname)
                result.append("Ifnames \t\t\t: %s"%', '.join(ifnames))
                if type == 'json':
                    json_dict['ifnames_adapter_%s'%(adapter_no)] = ','.join(ifnames)
            else:
                 result.append("No. of ports \t\t\t: NA")
                 result.append("Ifnames \t\t\t: NA")
                 if type == 'json':
                     json_dict['no_of_ports_adapter_%s'%(adapter_no)] = 'NA'
                     json_dict['ifnames_adapter_%s'%(adapter_no)] = 'NA'
                 
            result.append('\n')
    else:
        if type == 'json':
            json_dict['status'] = '-6'
            json_dict['error_msg'] = 'No cards present in the system.'
        else:
            print cmd_result
    
    if type == 'json':
        print simplejson.dumps(json_dict) 
    else:
        print '\n'.join(result)
    
def runCMD(cmd, type):
    #Running commands
    if type == 'string':
        print 'Please wait ....'
    
    p1 = os.popen(cmd, "r")
    return p1.read()

def removeLine( filename, lookup, entry ):
    #Get the line number of the lookup string
    with open(filename) as myFile:
        for num, line in enumerate(myFile, 0):
            if lookup in line:
                lineno = num

    #Use separate object for reading and writing
    fro = open(filename, "rb")
    current_line = 0
    new_content = []
    #Move the cursor to just before the lookup string
    while current_line < lineno:
        fro.readline()
        current_line += 1
        
    seekpoint = fro.tell()
    frw = open(filename, "r+b")
    frw.seek(seekpoint, 0)

    # read the line we want to discard
    temp = fro.readline()

    # now move the rest of the lines in the file 
    # one line back 
    chars = fro.readline()
    while chars:
        frw.writelines(chars)
        chars = fro.readline()

    #Update with the new entry
    frw.write(entry)

    fro.close()
    frw.truncate()
    frw.close()

if __name__ == '__main__':
	 main(sys.argv)
