from BulkDriverInstallFile import BulkDriverInstall
from xml.dom.minidom import Document
import os

import logging
import settings
logging.basicConfig(filename=settings.log_path,level=logging.DEBUG)

def index(req, **kwargs):
    data = {}
    
    try:
        data['action'] = kwargs['action']
        data['ip'] = kwargs['ip']
        data['sid'] = kwargs['sid']
    except:
        return -1
    
    if data['action'] == 'get_bookmarks':
        return invoke_get_bookmarks(data)
    
    try:
        data['username'] = kwargs['user']
        data['ostype'] = kwargs['ostype']
        file_id = kwargs['file_id']
        data['key_file'] = req.form[file_id]
        data['cardtype'] = kwargs['cardtype']
        data['drType'] = kwargs['drType']
        data['call_granted'] = kwargs['call_granted']
        data['driver_type'] = kwargs['driver_type']
        first_path = kwargs['first_path']
        upload_count = kwargs['upload_count'].strip()
    except:
        req.content_type = "application/xml"
        return generate_status_xml('-1')
    
    if data['ostype'] == '2' and data['driver_type'] == 'chelsio' and  data['cardtype'] == '1':
        try:
            data['conftype'] = kwargs['conftype']
        except:
            req.content_type = "application/xml"
            return generate_status_xml('-1')
    else:
        data['conftype'] = '0'
    
    if data['key_file'].filename:
        # strip leading path from file name to avoid directory traversal attacks
        data['fname'] = os.path.basename(data['key_file'].filename)
        data['drpath'] = upload_file(data)
        if not data['drpath']:
            req.content_type = "application/xml"
            return generate_status_xml('-1')
        
    if data['call_granted'] == 'yes' and data['driver_type'] == 'chelsio':
       
       data['ofedpath'] = ''
       data['ofedpkg'] = ''
       # Since data['call_granted'] == 'yes' , full upload is completed.
       # Notes if multiple upload for iscsi then always the first uploaded is iscsi file , the second one is the cxgb file
       # first_path contains the path of the file which got uploaded first.
       # data['drpath'] always contains the recently uploaded file path
       data['iscsipath'] = ''
       if data['drType'] == 'iscsi' and upload_count == 'multiple':
            data['iscsipath'] = first_path
       elif data['drType'] == 'iscsi' and upload_count == 'single':
            data['iscsipath'] = data['drpath']
            data['drpath'] = ''
       
       obj = BulkDriverInstall(data['sid'], data['ip'])
       result = obj.install_driver(data)
       req.content_type = "application/xml"
       return return_status(result)
      
    elif data['call_granted'] == 'yes' and data['driver_type'] == 'ofed':
        
        data['iscsipath'] = ''
        try:
            data['ofedpkg'] = kwargs['ofed_pkg']
        except:
            req.content_type = "application/xml"
            return return_status(-1)
        
        if upload_count == 'multiple':
           data['ofedpath'] = first_path
           data['ofedpkg'] = data['drpath']
           data['drpath'] = ''
        elif upload_count == 'single':
           data['ofedpath'] = data['drpath']
           data['drpath'] = ''
        
        obj = BulkDriverInstall(data['sid'], data['ip'])
        result = obj.install_driver(data)
        req.content_type = "application/xml"
        return return_status(result)
     
    elif data['call_granted'] == 'yes' and data['driver_type'] == 'um':
        data['iscsipath'] = ''
        data['ofedpkg'] = ''
        data['ofedpath'] = ''
        
        obj = BulkDriverInstall(data['sid'], data['ip'])
        result = obj.install_driver(data)
        req.content_type = "application/xml"
        return return_status(result)
    else:
       req.content_type = "application/xml"
       return generate_status_xml(data['drpath'])
    
def invoke_get_bookmarks(data):
    obj =  BulkDriverInstall(data['sid'], data['ip'])
    return obj.get_bookmarks()

def upload_file(data):
    try:
        dir_path = settings.get_user_folder_path(data['username'])
        filename = 'bk_driver_%s_%s'%( data['ip'].replace('.','_'), data['fname'].replace(' ','') )
        open(os.path.join(dir_path, filename), 'wb').write(data['key_file'].file.read())
        message = 'The file "%s" was uploaded successfully in the specified user path by python'%filename
        return dir_path+filename
    except:
        return 0
    
def generate_status_xml(status):
    doc = Document()
    driver_installation = doc.createElement("DriverInstallation")
    doc.appendChild(driver_installation)
    
    status_node = doc.createElement("status")
    driver_installation.appendChild(status_node)
    
    status_value = doc.createTextNode(str(status))
    status_node.appendChild(status_value)
    
    return doc.toprettyxml()

def generate_result_xml(result):
    doc = Document()
    driver_installation = doc.createElement("DriverInstallation")
    doc.appendChild(driver_installation)
    
    status_node = doc.createElement("status")
    driver_installation.appendChild(status_node)
    
    status_value = doc.createTextNode('0')
    status_node.appendChild(status_value)
    
    for i in result:
      if i != 'status':
          system_node = doc.createElement("system")
          driver_installation.appendChild(system_node)
          system_node.setAttribute("ip", i)
          system_node.setAttribute("status", result[i])
    
    return doc.toprettyxml()

def return_status(result):
    if result['status'] == 0:
      return generate_result_xml(result)
    elif result['status'] == -2:
      return generate_status_xml('-2')
    else:
      return generate_status_xml('-1')
  
