from BootFile import Boot
from DriverInfoFile import DriverDetails
import os
import logging
import settings
logging.basicConfig(filename=settings.log_path,level=logging.DEBUG)

def index(req, **kwargs):
    
    data = {}
    
    try:
        data['ip'] = kwargs['ip']
        data['sid'] = kwargs['sid']
        action = kwargs['action']
    except:
        return '-1'
    
    try:
        data['req_type'] = kwargs['req_type']
    except:
        data['req_type'] = 'desktop'
        

    if action == 'upload':
        try:
            data['username'] = kwargs['user']
            data['name'] = kwargs['name']
            data['card_index'] = kwargs['card_index']
            data['rom_file'] = req.form[data['name']]
        except:
            return '-1'
        
        data['fname'] = 'rom_%s.rom'%data['ip'].replace('.','_')
        upload_file(data)
        
        req.content_type = "application/xml"
        return upload_rom(data)
    
    elif action == 'upload_t4':
        try:
            data['username'] = kwargs['user']
            data['name'] = kwargs['name']
            data['card_index'] = kwargs['card_index']
            data['rom_file'] = req.form[data['name']]
        except:
            return '-1'
        
        data['fname'] = 't4_rom_%s.rom'%data['ip'].replace('.','_')
        upload_file(data)
        
        req.content_type = "application/xml"
        return upload_t4rom(data)
    
    elif action == 'erase_rom':
        try:
           data['card_index'] = kwargs['card_index'] 
        except:
            return '-1'
        return invoke_erase_rom(data)
    
    elif action == 'erase_t4_rom':
        try:
           data['card_index'] = kwargs['card_index'] 
        except:
            return '-1'
        return invoke_erase_t4rom(data)
    
    elif action == 'erase_settings':
        try:
           data['card_index'] = kwargs['card_index'] 
        except:
            return '-1'
        return invoke_erase_settings(data)
    
    elif action == 'get_data':
        try:
            data['pciloc'] = kwargs['pciloc']
            data['index'] = kwargs['card_index']
        except:
            return '-1'
        return invoke_get_data(data)
    
    elif action == 'set_properties':
        try:
            data['properties_count'] =  kwargs['properties_count']
            data['card_index'] =  kwargs['card_index']
            data['propname'] =  kwargs['propname']
            data['value'] =  kwargs['value']
            data['ostype'] =  kwargs['ostype']
        except:
            return -1
        return invoke_set_boot_settings(kwargs)
    
    elif action == 'get_t4_data':
        try:
            data['index'] = kwargs['card_index']
        except:
            return '-1'
        return invoke_get_t4_data(data)
    
    elif action == 'get_t4_conf_data':
        try:
            data['index'] = kwargs['card_index']
        except:
            return '-1'
        return invoke_get_t4_conf_data(data)
    
    elif action == 'get_fcoe_driver_status':
        
        try:
            ostype = kwargs['ostype']
        except:
            return '-1'
        
        obj = DriverDetails(data['sid'], data['ip'], 'desktop')
        return obj.is_fcoe_loaded(int(ostype))
    
    elif action == 'discover_targets':
        
        try:
            data['card_index'] = kwargs['card_index']
            data['ostype'] = kwargs['ostype']
        except:
            return '-1'
        
        return invoke_get_targets(data)
    
    elif action == 'set_default_t4_settings':
        try:
            data['card_index'] = kwargs['card_index']
        except:
            return '-1'
        
        return invoke_set_default_t4_settings(data)
    
    elif action == 'save_t4_adapter_config':
        try:
            data['card_index'] = kwargs['card_index']
            data['propname'] = kwargs['propname']
            data['value'] = kwargs['value']
            data['ostype'] = kwargs['ostype']
            data['properties_count'] = kwargs['properties_count']
        except:
            return '-1'
        
        return invoke_set_t4_properties(data)
    
    elif action == 'save_t4_pxe_config':
        try:
            data['card_index'] = kwargs['card_index']
            data['propname'] = kwargs['propname']
            data['value'] = kwargs['value']
            data['ostype'] = kwargs['ostype']
            data['properties_count'] = kwargs['properties_count']
        except:
            return '-1'
        
        return invoke_set_t4_properties(data)
    
    elif action == 'save_t4_fcoe_config':
        try:
            data['card_index'] = kwargs['card_index']
            data['propname'] = kwargs['propname']
            data['value'] = kwargs['value']
            data['properties_count'] = kwargs['properties_count']
            data['ostype'] = kwargs['ostype']
        except:
            return '-1'
        return invoke_set_t4_properties(data)
    
    elif action == 'save_t4_iscsi_config':
        try:
            data['card_index'] = kwargs['card_index']
            data['propname'] = kwargs['propname']
            data['value'] = kwargs['value']
            data['properties_count'] = kwargs['properties_count']
            data['ostype'] = kwargs['ostype']
        except:
            return '-1'
        return invoke_set_t4_properties(data)

    else:
        return -1

def upload_file(data):
    
    # Test if the file was uploaded
    if data['rom_file'].filename:
        # build absolute path to files directory
        dir_path = '%s%s'%(settings.document_root_path,data['username'])
        open(os.path.join(dir_path, data['fname']), 'wb').write(data['rom_file'].file.read())
        message = 'The Option Rom file "%s" was uploaded successfully in the specified user path by python' % data['fname']
        logging.info(message)
    else:
        message = 'No file was uploaded'
        logging.info(message)
    
def upload_rom(data):
    boot_obj = Boot(data['sid'], data['ip'])
    return boot_obj.flash_rom(data)

def upload_t4rom(data):
    boot_obj = Boot(data['sid'], data['ip'])
    return boot_obj.flash_t4rom(data)

def invoke_get_data(data):
    boot_obj = Boot(data['sid'], data['ip'])
    return boot_obj.get_data(data)

def invoke_erase_rom(data):
    boot_obj = Boot(data['sid'], data['ip'])
    return boot_obj.erase_rom(data['card_index'])

def invoke_erase_t4rom(data):
    boot_obj = Boot(data['sid'], data['ip'])
    return boot_obj.erase_t4rom(data['card_index'])

def invoke_erase_settings(data):
    boot_obj = Boot(data['sid'], data['ip'])
    return boot_obj.erase_settings(data['card_index'])

def invoke_set_boot_settings(data):
    boot_obj = Boot(data['sid'], data['ip'])
    return boot_obj.set_boot_settings(data)

def invoke_get_t4_data(data):
    boot_obj = Boot(data['sid'], data['ip'])
    return boot_obj.get_t4_data(data)

def invoke_get_t4_conf_data(data):
    boot_obj = Boot(data['sid'], data['ip'])
    return boot_obj.get_t4_conf_data(data)

def invoke_get_targets(data):
    boot_obj = Boot(data['sid'], data['ip'])
    return boot_obj.get_targets(data)

def invoke_set_default_t4_settings(data):
    boot_obj = Boot(data['sid'], data['ip'])
    return boot_obj.set_default_t4_settings(data)

def invoke_set_t4_properties(data):
    boot_obj = Boot(data['sid'], data['ip'])
    return boot_obj.set_t4_properties(data)
