from UmBoostLib import VMList, XenVMsList, Xen_vmSummary, Xen_VfSummary
import time
import logging
import settings
logging.basicConfig(filename=settings.log_path,level=logging.DEBUG)

class XenConfiguration(object):
    def __init__(self, sid, ip):
        self.sid = sid
        self.ip = ip

    def get_xen_conf_data(self):
        self.agmtVMListObj = VMList()
        self.mainXenVMsListObj = XenVMsList()
        logging.info('Get Xen Configuration Data ListVMs waiting for response from UMboost sid : %s , IP : %s'%(self.sid, self.ip))
        status = self.mainXenVMsListObj.ListVMs(self.agmtVMListObj, self.sid, self.ip)
        logging.info('Get Xen Configuration Data ListVMs status: %s'%status)
        
        if status == 0:
            return self.generateHtml()
        elif status == -2:
            return -2
        else:
            return -1
        
    def generateHtml(self):
        
        unique_parent_id = '#system_content__incend__'+ self.ip.replace('.','_') +' .system_xen_conf_tab';
        html = '<li class="vms" onclick="display_xen_conf_data(\''+ unique_parent_id +'\', $(this))">%s\
                <input type = "hidden" value = "%s" class = "uuid" />\
                <input type = "hidden" value = "%s" class = "ps" />\
                <input type = "hidden" value = "%s" class = "vfpci" />\
                </li>'
                
        html_list = [ html%( self.mainXenVMsListObj.get(self.agmtVMListObj,i).name_label,\
                             self.mainXenVMsListObj.get(self.agmtVMListObj,i).uuid,\
                             self.mainXenVMsListObj.get(self.agmtVMListObj,i).powerstate,\
                             self.mainXenVMsListObj.get(self.agmtVMListObj,i).vfpci)\
                     for i in range(len(self.agmtVMListObj)) ]
        
        return '<ul class="vm_ul">'+''.join(html_list)+'</ul>'
    
    def perform_operation(self, data):
        Obj = Xen_vmSummary()
        #Slicing the string removing the first and last comma.
        vm_uuid = data['vm_uid'][1:len(data['vm_uid'])-1]
        vm_uuid_list = vm_uuid.split(',,')
        
        if len(vm_uuid_list) > 1:
            for i in vm_uuid_list:
                logging.info('Mult Perform Xen Configuration operation waiting for response from UMboost sid : %s , IP : %s, \
                              vm_uuid : %s, operation : %s'%(self.sid, self.ip, i, data['operation']))
                status = Obj.PerformVMoperations(self.sid, self.ip, i, int(data['operation']))
                logging.info('Perform Xen Configuration operation status: %s'%status)
        else:
             logging.info('Single Perform Xen Configuration operation waiting for response from UMboost sid : %s , IP : %s, \
                          vm_uuid : %s, operation : %s'%(self.sid, self.ip, vm_uuid, data['operation']))
             status = Obj.PerformVMoperations(self.sid, self.ip, vm_uuid, int(data['operation']))
             logging.info('Perform Xen Configuration operation status: %s'%status)
             
        if status == 0:
            time.sleep(10)
            return status
        elif status == 0:
            return status
        else:
            return -1
        
    def remove_vf(self, data):
        Obj = Xen_VfSummary()
        #Slicing the string removing the first and last comma.
        vm_uuid = data['vm_uid'][1:len(data['vm_uid'])-1]
        vm_uuid_list = vm_uuid.split(',,')
        
        if len(vm_uuid_list) > 1:
            for i in vm_uuid_list:
                logging.info('Mult Xen Configuration remove VF - sid : %s , IP : %s, \
                              vm_uuid : %s'%(self.sid, self.ip, i))
                status = Obj.RemoveVfsFromVMs(self.sid, self.ip, i)
                logging.info('Perform Xen Configuration operation status: %s'%status)
        else:
             logging.info('Single Xen Configuration remove VF - sid : %s , IP : %s, \
                          vm_uuid : %s'%(self.sid, self.ip, vm_uuid))
             status = Obj.RemoveVfsFromVMs(self.sid, self.ip, vm_uuid)
             logging.info('Perform Xen Configuration operation status: %s'%status)
             
        if status == 0:
            time.sleep(10)
            return status
        elif status == 0:
            return status
        else:
            return -1