from UmBoostLib import XenBridgeList, BridgeList, XenVifList, XenPifList, VMList, XenVMsList, Xen_BridgeSummary, PifList, VifList, Xen_vifSummary
import settings, utils
logging = settings.get_logger()

class XenBridgeConf(object):
    
    def __init__(self, sid, ip, type):
        self.sid = sid
        self.ip = ip
        self.type = type
    
    def get_xen_tree(self):
        
        status = self.list_pifs()
        
        self.vfs_dict = { 'is_vifs_exists': 0 }
        status1 = self.list_vfs()
        
        self.vms_dict = { 'is_vms_exists': 0 }
        status2 = self.list_vms()
        
        if status == -2 or status1 == -2 or status2 == -2:
            return status
        else:
            return self.generate_bridge_tree()

    
    def delete_bridge(self, id):
        
        logging.info('Hypervisor - Xen Bridge Configuration  delete bridge : Sid : %s, Ip : %s, id : %s'%( self.sid, self.ip, id ))
        self.mainXen_BridgeSummarytobj = Xen_BridgeSummary()
        status = self.mainXen_BridgeSummarytobj.DeleteBridge(self.sid, self.ip, id )
        logging.info('Hypervisor - Xen Bridge delete bridge status : %s'%( status ))
        if status == 0 or status == -2:
            return  status
        else:
            return utils.get_error_string(status)
        
    def delete_vif(self, id):
        
        logging.info('Hypervisor - Xen Bridge Configuration  delete vif : Sid : %s, Ip : %s, id : %s'%( self.sid, self.ip, id ))
        self.mainXen_vifSummarytobj = Xen_vifSummary()
        status = self.mainXen_vifSummarytobj.DeleteVif(self.sid, self.ip, id )
        logging.info('Hypervisor - Xen Bridge delete vif status : %s'%( status ))
        
        if status == 0 or status == -2:
            return  status
        else:
            return utils.get_error_string(status)
    
    
    def list_pifs(self):
        
        logging.info('Hypervisor - Xen Bridge Configuration  ListPifs : Sid : %s, Ip : %s'%( self.sid, self.ip ))
        self.mainXenPifListobj = XenPifList()
        self.agmtPifListobj = PifList()
        status = self.mainXenPifListobj.ListPifs( self.agmtPifListobj, self.sid, self.ip )
        logging.info('Hypervisor - Xen Bridge Configuration ListPifs status : %s'%( status ))
        
        if status == 0:
            self.pifs_dict = {}
            for i in range(0,len(self.agmtPifListobj)):
                current_pifs_dict = {}
                current_pifs_dict['vendor_id'] = self.mainXenPifListobj.get(self.agmtPifListobj,i).vendor_id
                current_pifs_dict['vlan'] = self.mainXenPifListobj.get(self.agmtPifListobj,i).vlan
                current_pifs_dict['physical'] = self.mainXenPifListobj.get(self.agmtPifListobj,i).physical
                current_pifs_dict['device_id'] = self.mainXenPifListobj.get(self.agmtPifListobj,i).device_id
                current_pifs_dict['devname'] = self.mainXenPifListobj.get(self.agmtPifListobj,i).devname
                logging.info('speed : %s'%self.mainXenPifListobj.get(self.agmtPifListobj,i).speed)
                logging.info('vendor_name : %s'%self.mainXenPifListobj.get(self.agmtPifListobj,i).vendor_name)
                logging.info('device_id : %s'%self.mainXenPifListobj.get(self.agmtPifListobj,i).device_id)
                logging.info('device_name : %s'%self.mainXenPifListobj.get(self.agmtPifListobj,i).device_name)
                current_pifs_dict['speed'] = self.mainXenPifListobj.get(self.agmtPifListobj,i).speed
                current_pifs_dict['device_name'] = self.mainXenPifListobj.get(self.agmtPifListobj,i).device_name
                current_pifs_dict['pci_bus_path'] = self.mainXenPifListobj.get(self.agmtPifListobj,i).pci_bus_path
                current_pifs_dict['vendor_name'] = self.mainXenPifListobj.get(self.agmtPifListobj,i).vendor_name
                current_pifs_dict['network_uuid'] = self.mainXenPifListobj.get(self.agmtPifListobj,i).network_uuid
                current_pifs_dict['network_name_label'] = self.mainXenPifListobj.get(self.agmtPifListobj,i).network_name_label
                current_pifs_dict['mac_pif'] = self.mainXenPifListobj.get(self.agmtPifListobj,i).mac_pif
                self.pifs_dict[self.mainXenPifListobj.get(self.agmtPifListobj,i).uuid] = current_pifs_dict
        elif status == -2:
            return status
        else:
            return -1
    
    
    def list_vfs(self):
        
        logging.info('Hypervisor - Xen Bridge Configuration  ListVifs : Sid : %s, Ip : %s'%( self.sid, self.ip ))
        self.mainXenVifListobj = XenVifList()
        self.agmtVifListobj = VifList()
        status = self.mainXenVifListobj.ListVifs( self.agmtVifListobj, self.sid, self.ip )
        logging.info('Hypervisor - Xen Bridge Configuration ListVifs status : %s, len : %s'%( status, len(self.agmtVifListobj) ))
        
        if status == 0:
            self.vfs_dict = {}
            for i in range(0,len(self.agmtVifListobj)):
                self.vfs_dict['is_vifs_exists'] = 1
                current_vif_dic = {}
                current_vif_dic['vm_uuid'] = self.mainXenVifListobj.get(self.agmtVifListobj,i).vm_uuid
                current_vif_dic['vm_name_label'] = self.mainXenVifListobj.get(self.agmtVifListobj,i).vm_name_label
                current_vif_dic['device'] = self.mainXenVifListobj.get(self.agmtVifListobj,i).device
                current_vif_dic['mac_pif'] = self.mainXenVifListobj.get(self.agmtVifListobj,i).mac_pif
                current_vif_dic['mac_type'] = self.mainXenVifListobj.get(self.agmtVifListobj,i).mac_type
                current_vif_dic['vif_mtu'] = self.mainXenVifListobj.get(self.agmtVifListobj,i).vif_mtu
                current_vif_dic['attach_type'] = self.mainXenVifListobj.get(self.agmtVifListobj,i).attach_type
                current_vif_dic['network_uuid'] = self.mainXenVifListobj.get(self.agmtVifListobj,i).network_uuid
                current_vif_dic['network_name_label'] = self.mainXenVifListobj.get(self.agmtVifListobj,i).network_name_label
                self.vfs_dict[self.mainXenVifListobj.get(self.agmtVifListobj,i).vif_uuid] = current_vif_dic
        elif status == -2:
            return status
        else:
            return -1
        
    
    def list_vms(self):
        
        self.agmtVMListObj = VMList()
        self.mainXenVMsListObj = XenVMsList()
        
        logging.info('Hypervisor - Xen Bridge Configuration List VMs sid : %s , IP : %s'%(self.sid, self.ip))
        status = self.mainXenVMsListObj.ListVMs(self.agmtVMListObj, self.sid, self.ip)
        logging.info('Hypervisor - Xen Bridge Configuration List VMs status: %s'%status)
        
        if status == 0:
            self.vms_dict = {}
            for i in range(len(self.agmtVMListObj)):
                self.vms_dict['is_vms_exists'] = 1
                current_vms_dict = {}
                current_vms_dict['name_label'] = self.mainXenVMsListObj.get(self.agmtVMListObj,i).name_label
                current_vms_dict['vfpci'] = self.mainXenVMsListObj.get(self.agmtVMListObj,i).vfpci
                current_vms_dict['powerstate'] = self.mainXenVMsListObj.get(self.agmtVMListObj,i).powerstate
                current_vms_dict['uuid'] = self.mainXenVMsListObj.get(self.agmtVMListObj,i).uuid
                self.vms_dict[self.mainXenVMsListObj.get(self.agmtVMListObj,i).uuid] = current_vms_dict 
        elif status == -2:
            return -2
        else:
            return -1
        
    def generate_bridge_tree(self):
        
        logging.info('Hypervisor - Xen Bridge Configuration  ListBridges : Sid : %s, Ip : %s'%( self.sid, self.ip ))
        self.mainXenBridgeListobj = XenBridgeList()
        self.agmtBridgeListobj = BridgeList()
        status = self.mainXenBridgeListobj.ListBridges( self.agmtBridgeListobj, self.sid, self.ip )
        logging.info('Hypervisor - Xen Bridge Configuration  ListBridges status : %s'%( status ))
        
        if status == 0:
            return  self.build_bridge_tree()
        elif status == -2:
            return -2
        
    def build_bridge_tree(self):
        
        plus = '<a class="tree_action" href="javascript:void(0);"><img src="/images/black/tree_plus.png"></a>'
        minus = '<a class="tree_action" href="javascript:void(0);"><img src="/images/black/tree_minus.png"></a>'
        ip_id = self.ip.replace('.','_')
        unique_parent_id = '#hypervisor_xen_content__incend__'+ip_id+' .xen_bridge_conf_tab'
        tree_html = ''
        
        for i in range(len(self.agmtBridgeListobj)):
            bridge_name = self.mainXenBridgeListobj.get(self.agmtBridgeListobj,i).bridge_name
            num_vif = self.mainXenBridgeListobj.get(self.agmtBridgeListobj,i).num_vif
            num_pif = self.mainXenBridgeListobj.get(self.agmtBridgeListobj,i).num_pif
            vif_uuid = self.mainXenBridgeListobj.get(self.agmtBridgeListobj,i).vif_uuid
            pif_uuid = self.mainXenBridgeListobj.get(self.agmtBridgeListobj,i).pif_uuid
            child_flag = False
	   
            
            #Pif - eth
            pif_html_w = ''
            if num_pif > 0 and pif_uuid != 'NONE':
                #pif_html = '<ul class="as_hide">\
                pif_html = '<ul>\
                                <li>\
                                    <a onclick="xen_conf_select(\'%s\', $(this), \'pif\')" href="javascript:void(0);" ><img class="icon" src="images/black/pg_col.png">%s\
                                        <input type="hidden" class="vendor_id"  value="%s"  />\
                                        <input type="hidden" class="vlan"  value="%s"  />\
                                        <input type="hidden" class="physical"  value="%s"  />\
                                        <input type="hidden" class="device_id"  value="%s"  />\
                                        <input type="hidden" class="devname"  value="%s"  />\
                                        <input type="hidden" class="speed"  value="%s"  />\
                                        <input type="hidden" class="device_name"  value="%s"  />\
                                        <input type="hidden" class="pci_bus_path"  value="%s"  />\
                                        <input type="hidden" class="vendor_name"  value="%s"  />\
                                        <input type="hidden" class="uuid"  value="%s"  />\
                                        <input type="hidden" class="network_uuid"  value="%s"  />\
                                        <input type="hidden" class="network_name_label"  value="%s"  />\
                                        <input type="hidden" class="mac_pif"  value="%s"  />\
                                    </a>\
                                </li>\
                            </ul>'
                
                pif_id_list = pif_uuid.split(',')
                
                if len(pif_id_list) > 1:
	            for id in pif_id_list:
	              if self.pifs_dict.has_key(id):
                          child_flag = True
                          pif_html_list =  pif_html%( unique_parent_id, self.pifs_dict[id]['devname'], self.pifs_dict[id]['vendor_id'], self.pifs_dict[id]['vlan'],
                                                     self.pifs_dict[id]['physical'],
                                                     self.pifs_dict[id]['device_id'], self.pifs_dict[id]['devname'],
                                                     self.pifs_dict[id]['speed'], self.pifs_dict[id]['device_name'],
                                                     self.pifs_dict[id]['pci_bus_path'],
                                                     self.pifs_dict[id]['vendor_name'], id, self.pifs_dict[id]['network_uuid'], self.pifs_dict[id]['network_name_label'],
                                                     self.pifs_dict[id]['mac_pif']
                                                     ) 
                          pif_html_w += pif_html_list
                else:
                    id = pif_id_list[0]
                    if self.pifs_dict.has_key(id):
                        child_flag = True
                        pif_html_w = pif_html%(  unique_parent_id, self.pifs_dict[id]['devname'], self.pifs_dict[id]['vendor_id'], self.pifs_dict[id]['vlan'],
                                                 self.pifs_dict[id]['physical'], self.pifs_dict[id]['device_id'], self.pifs_dict[id]['devname'], 
                                                 self.pifs_dict[id]['speed'], self.pifs_dict[id]['device_name'], self.pifs_dict[id]['pci_bus_path'],
                                                 self.pifs_dict[id]['vendor_name'], id, self.pifs_dict[id]['network_uuid'], self.pifs_dict[id]['network_name_label'],
                                                 self.pifs_dict[id]['mac_pif'] ) 
            
            #Vif
            vif_html_w = ''
            if num_vif > 0 and vif_uuid != 'NONE':
                child_flag = True
                #vif_html = '<ul class="as_hide">\
                vif_html = '<ul>\
                               <li>%s\
                                    <a onclick="xen_conf_select(\'%s\', $(this), \'vif\')" href="javascript:void(0);" class=""><img src="images/black/v_network.png" class="icon">vif%s\
                                    <input type="hidden" class="vif_uuid"  value="%s"  />\
                                    <input type="hidden" class="device"  value="%s"  />\
                                    <input type="hidden" class="mac_pif"  value="%s"  />\
                                    <input type="hidden" class="mac_type"  value="%s"  />\
                                    <input type="hidden" class="vif_mtu"  value="%s"  />\
                                    <input type="hidden" class="attach_type"  value="%s"  />\
                                    <input type="hidden" class="network_uuid"  value="%s"  />\
                                    <input type="hidden" class="network_name_label"  value="%s"  />\
                                    <input type="hidden" class="vm_name_label"  value="%s"  />\
                                    <input type="hidden" class="vm_uuid"  value="%s"  />\
                                    </a>%s\
                                </li>\
                            </ul>'
                
                vif_id_list = vif_uuid.split(',')
                
                vif_html_w  = ''
                label = 0
                if len(vif_id_list) > 1 and self.vfs_dict['is_vifs_exists']:
                   for id in vif_id_list:
		     if self.vfs_dict.has_key(id):
                        vm_uuid = self.vfs_dict[id]['vm_uuid'].strip()
                        if self.vms_dict.has_key(vm_uuid):
                           if vm_uuid != '':
                               vf_plus = plus
                           else:
                               vf_plus = ''
                                
                            #VM
                           vm_html = '<ul class="as_hide">\
                                             <li>\
                                                <a onclick="xen_conf_select(\'%s\', $(this), \'vm\')" href="javascript:void(0);"><img src="images/black/pg_col.png" class="icon">%s\
                                                <input type="hidden" class="name_label"  value="%s" />\
                                                <input type="hidden" class="uuid"  value="%s" />\
                                                <input type="hidden" class="vfpci"  value="%s" />\
                                                <input type="hidden" class="powerstate"  value="%s" />\
                                                </a>\
                                            </li>\
                                       </ul>'%( unique_parent_id, self.vms_dict[vm_uuid]['name_label'],self.vms_dict[vm_uuid]['name_label'], self.vms_dict[vm_uuid]['uuid'], self.vms_dict[vm_uuid]['vfpci'],
                                               self.vms_dict[vm_uuid]['powerstate'])
                            
                           vif_html_w += vif_html%( vf_plus, unique_parent_id, label, id, self.vfs_dict[id]['device'], self.vfs_dict[id]['mac_pif'],
                                                     self.vfs_dict[id]['mac_type'], self.vfs_dict[id]['vif_mtu'], self.vfs_dict[id]['attach_type'],
                                                     self.vfs_dict[id]['network_uuid'], self.vfs_dict[id]['network_name_label'], self.vfs_dict[id]['vm_name_label'],
                                                     self.vfs_dict[id]['vm_uuid'], vm_html )
                           label += 1
                else:
                    id = vif_id_list[0]
                    
                    if self.vfs_dict['is_vifs_exists']:
                        vm_uuid = self.vfs_dict[id]['vm_uuid'].strip()
                    else:
                        vm_uuid = None
                    
                    if self.vms_dict.has_key(vm_uuid):
                        if vm_uuid != '':
                            vf_plus = plus
                        else:
                            vf_plus = ''
                            
                        #VM
                        vm_name = self.vms_dict[vm_uuid]['name_label']
                        vm_html = '<ul class="as_hide">\
                                            <li>\
                                                <a onclick="xen_conf_select(\'%s\', $(this), \'vm\')" href="javascript:void(0);"><img src="images/black/pg_col.png" class="icon">%s\
                                                <input type="hidden" class="name_label"  value="%s" />\
                                                <input type="hidden" class="uuid"  value="%s"  />\
                                                <input type="hidden" class="vfpci"  value="%s"  />\
                                                <input type="hidden" class="powerstate"  value="%s"  />\
                                                </a>\
                                            </li>\
                                       </ul>'%( unique_parent_id, self.vms_dict[vm_uuid]['name_label'], self.vms_dict[vm_uuid]['name_label'], self.vms_dict[vm_uuid]['uuid'], self.vms_dict[vm_uuid]['vfpci'],
                                               self.vms_dict[vm_uuid]['powerstate'])
                        
                        vif_html_w += vif_html%( vf_plus, unique_parent_id, label, id, self.vfs_dict[id]['device'], self.vfs_dict[id]['mac_pif'],
                                                     self.vfs_dict[id]['mac_type'], self.vfs_dict[id]['vif_mtu'], self.vfs_dict[id]['attach_type'],
                                                     self.vfs_dict[id]['network_uuid'], self.vfs_dict[id]['network_name_label'], self.vfs_dict[id]['vm_name_label'],
                                                     self.vfs_dict[id]['vm_uuid'], vm_html )
           
            #Bridge plus will be added only if it has a child
            if child_flag:
                #b_plus = plus
                b_plus = minus
            else:
                b_plus = ''
            
            
            bridge_desc_title =  bridge_desc = self.mainXenBridgeListobj.get(self.agmtBridgeListobj,i).network_name_description
            if(len(bridge_desc) > 49):
                bridge_desc = bridge_desc[0:40]+' ...'
                
            tree_html += '<li class="vm_tree_li">%s\
                             <a class="first_br" onclick="xen_conf_select(\'%s\', $(this), \'bridge\')" href="javascript:void(0);"><img src="images/black/b.png" class="icon">%s\
                                 <input type="hidden" class="network_uuid"  value="%s"  />\
                                 <input type="hidden" class="network_name_label"  value="%s"  />\
                                 <input type="hidden" class="network_name_description"  value="%s"  />\
                                 <input type="hidden" class="bridge_desc_title"  value="%s"  />\
                                 <input type="hidden" class="vif_uuid"  value="%s"  />\
                                 <input type="hidden" class="pif_uuid"  value="%s"  />\
                                 <input type="hidden" class="vif_mtu"  value="%s"  />\
                            </a>%s%s</li>\
                        '%( b_plus, unique_parent_id, self.mainXenBridgeListobj.get(self.agmtBridgeListobj,i).bridge_name, 
                            self.mainXenBridgeListobj.get(self.agmtBridgeListobj,i).network_uuid,
                            self.mainXenBridgeListobj.get(self.agmtBridgeListobj,i).network_name_label, bridge_desc, bridge_desc_title,
                            self.mainXenBridgeListobj.get(self.agmtBridgeListobj,i).vif_uuid, self.mainXenBridgeListobj.get(self.agmtBridgeListobj,i).pif_uuid,
                            self.mainXenBridgeListobj.get(self.agmtBridgeListobj,i).mtu,
                            pif_html_w, vif_html_w )
            
        return '<ul class="tree_ul">'+tree_html+'</ul>'
