from UmBoostLib import VMsList, win_VMList, VM_Summary
import time
import settings
logging = settings.get_logger()

class WinVmConfiguration(object):
    def __init__(self, sid, ip):
        self.sid = sid
        self.ip = ip

    def get_winvm_conf_data(self):
        self.agmtVMListObj = win_VMList()
        self.mainwinvmVMsListObj = VMsList()
        logging.info('Get winvm Configuration Data ListVMs waiting for response from UMboost sid : %s , IP : %s'%(self.sid, self.ip))
        status = self.mainwinvmVMsListObj.ListVMs(self.agmtVMListObj, self.sid, self.ip)
        logging.info('Get winvm Configuration Data ListVMs status: %s'%status)
        
        if status == 0:
            return self.generateHtml()
        elif status == -2:
            return -2
        else:
            return -1
        
    def generateHtml(self):
        
        unique_parent_id = '#system_content__incend__'+ self.ip.replace('.','_') +' .system_win_vm_conf_tab';
        html = '<li class="vms" onclick="display_winvm_conf_data(\''+ unique_parent_id +'\', $(this))">%s\
                <input type = "hidden" value = "%s" class = "guid" />\
                <input type = "hidden" value = "%s" class = "ps" />\
                <input type = "hidden" value = "%s" class = "health_state" />\
                </li>'
                
        html_list = [ html%( self.mainwinvmVMsListObj.get(self.agmtVMListObj,i).VMName,\
                             self.mainwinvmVMsListObj.get(self.agmtVMListObj,i).guid,\
                             self.mainwinvmVMsListObj.get(self.agmtVMListObj,i).PowerState,\
                             self.mainwinvmVMsListObj.get(self.agmtVMListObj,i).HealthState)\
                     for i in range(len(self.agmtVMListObj)) ]
        
        return '<ul class="vm_ul">'+''.join(html_list)+'</ul>'
    
    def perform_operation(self, data):
        Obj = VM_Summary()
        #Slicing the string removing the first and last comma.
        vm_uuid = data['vm_uid'][1:len(data['vm_uid'])-1]
        vm_uuid_list = vm_uuid.split(',,')
        
        if len(vm_uuid_list) > 1:
            for i in vm_uuid_list:
                logging.info('Mult Perform winvm Configuration operation waiting for response from UMboost sid : %s , IP : %s, \
                              vm_uuid : %s, operation : %s'%(self.sid, self.ip, i, data['operation']))
                status = Obj.PerformVMoperations(self.sid, self.ip, i, int(data['operation']))
                logging.info('Perform winvm Configuration operation status: %s'%status)
        else:
             logging.info('Single Perform winvm Configuration operation waiting for response from UMboost sid : %s , IP : %s, \
                          vm_uuid : %s, operation : %s'%(self.sid, self.ip, vm_uuid, data['operation']))
             status = Obj.PerformVMoperations(self.sid, self.ip, vm_uuid, int(data['operation']))
             logging.info('Perform winvm Configuration operation status: %s'%status)
             
        if status == 0:
            time.sleep(10)
            return status
        elif status == 0:
            return status
        else:
            return -1
