from UmBoostLib import VMsList, win_VMList, winVSwitchList, winSwitchList, winSwitch_Summary, VM_Summary
import settings, utils
logging = settings.get_logger()

class WinVmConf(object):
    
    def __init__(self, sid, ip, type):
        self.sid = sid
        self.ip = ip
        self.type = type
    
    def get_win_tree(self):
        
        status = self.list_vms()
        
        if status == -2 or status == -1:
            return status
        else:
            return self.generate_Switch_tree()

    def delete_switch(self, id):
        
        logging.info('Hypervisor - win Switch Configuration  delete Switch : Sid : %s, Ip : %s, id : %s'%( self.sid, self.ip, id ))
        self.mainwin_SwitchSummarytobj = winSwitch_Summary()
        status = self.mainwin_SwitchSummarytobj.DeleteVswitch(self.sid, self.ip, id )
        logging.info('Hypervisor - win Switch delete Switch status : %s'%( status ))
        
        if status == 0 or status == -2:
            return  status
        else:
            return utils.get_error_string(status)
        
    def list_vms(self):
        
        self.agmtVMListObj = win_VMList()
        self.mainwinVMsListObj = VMsList()
        logging.info('Hypervisor - win Switch Configuration List VMs sid : %s , IP : %s'%(self.sid, self.ip))
        status = self.mainwinVMsListObj.ListVMs(self.agmtVMListObj, self.sid, self.ip)
        logging.info('Hypervisor - win Switch Configuration List VMs status: %s'%status)
        
        if status == 0:
            self.vms_dict = {}
            for i in range(len(self.agmtVMListObj)):
		    current_vms_dict = {}
		    current_vms_dict['VMName'] = self.mainwinVMsListObj.get(self.agmtVMListObj,i).VMName
		    current_vms_dict['HealthState'] = self.mainwinVMsListObj.get(self.agmtVMListObj,i).HealthState
		    current_vms_dict['PowerState'] = self.mainwinVMsListObj.get(self.agmtVMListObj,i).PowerState
		    current_vms_dict['guid'] = self.mainwinVMsListObj.get(self.agmtVMListObj,i).guid
		    current_vms_dict['vnic_list'] = self.mainwinVMsListObj.get(self.agmtVMListObj,i).vNicList
        	    logging.info('Hypervisor - win Switch Configuration: Attached Nic List : %s'%(self.mainwinVMsListObj.get(self.agmtVMListObj,i).vNicList)
		    self.vms_dict[current_vms_dict['guid']] = current_vms_dict 
        else:
            return -1
        
    def generate_Switch_tree(self):
        
        logging.info('Hypervisor - win Switch Configuration  ListSwitchs : Sid : %s, Ip : %s'%( self.sid, self.ip ))
        self.mainwinSwitchListobj = winVSwitchList()
        self.agmtSwitchListobj = winSwitchList()
        logging.info('Hypervisor - Calliing win Switch Configuration  ListSwitchs : Sid : %s, Ip : %s'%( self.sid, self.ip ))
        status = self.mainwinSwitchListobj.ListvNetworks( self.agmtSwitchListobj, self.sid, self.ip )
        logging.info('Hypervisor - win Switch Configuration  ListSwitchs status : %s, len : %s'%( status,  len(self.agmtSwitchListobj)))
        
        if status == 0:
            return  self.build_Switch_tree()
        elif status == -2:
            return -2
        
    def build_Switch_tree(self):
        
        plus = '<a class="tree_action" href="javascript:void(0);"><img src="/images/black/tree_plus.png"></a>'
        minus = '<a class="tree_action" href="javascript:void(0);"><img src="/images/black/tree_minus.png"></a>'
        ip_id = self.ip.replace('.','_')
        unique_parent_id = '#hypervisor_win_content__incend__'+ip_id+' .win_Switch_conf_tab'
        tree_html = ''
        vm_html = ''

	for key in self.vms_dict:
		child_flag = False
		switch =""
		for i in range(len(self.agmtSwitchListobj)):
				logging.info('Hypervisor - interface : %s'%(self.mainwinSwitchListobj.get(self.agmtSwitchListobj,i).networkIntf))
                     if  'chelsio' == self.mainwinSwitchListobj.get(self.agmtSwitchListobj,i).networkIntf:
                      #if  current_vms_dict['vnic_list'] == self.mainwinSwitchListobj.get(self.agmtSwitchListobj,i).networkIntf:
				child_flag = False
				switch +=  '<ul class="">\
						<li>\
							<a onclick="win_conf_select(\'%s\', $(this), \'switch\')" \
								href="javascript:void(0);" class="switch">\
								<img src="images/black/switch2.png" class="icon">%s\
							<input type="hidden" class="switchname"  value="%s" />\
							<input type="hidden" class="guid"  value="%s" />\
							<input type="hidden" class="networkIntf"  value="%s" />\
							<input type="hidden" class="portGUID"  value="%s" />\
							<input type="hidden" class="HealthState"  value="%s" />\
							<input type="hidden" class="EnabledState"  value="%s" />\
							<input type="hidden" class="PortType"  value="%s" />\
							<input type="hidden" class="PortName"  value="%s" />\
							</a>\
						</li>\
					    </ul>\
				'%( unique_parent_id,
				self.mainwinSwitchListobj.get(self.agmtSwitchListobj,i).vSwitchName,
				self.mainwinSwitchListobj.get(self.agmtSwitchListobj,i).guid,
				self.mainwinSwitchListobj.get(self.agmtSwitchListobj,i).networkIntf,
				self.mainwinSwitchListobj.get(self.agmtSwitchListobj,i).portGUID, 
				self.mainwinSwitchListobj.get(self.agmtSwitchListobj,i).HealthState,
				self.mainwinSwitchListobj.get(self.agmtSwitchListobj,i).EnabledState,
				self.mainwinSwitchListobj.get(self.agmtSwitchListobj,i).PortType, 
				Self.mainwinSwitchListobj.get(self.agmtSwitchListobj,i).PortName
				)
		if child_flag:
			b_plus = plus
		else:
			b_plus = ''

		tree_html += 	'<li class="vm_tree_li">%s\
					<a onclick="win_conf_select(\'%s\', $(this), \'vm\')" href="javascript:void(0);">\
						<img src="images/black/pg_col.png" class="icon">%s\
                                        	<input type="hidden" class="name_label"  value="%s" />\
	                                        <input type="hidden" class="uuid"  value="%s" />\
        	                                <input type="hidden" class="HealthState"  value="%s"  />\
                	                        <input type="hidden" class="powerstate"  value="%s"  />\
                                        </a>%s</li>\
				'%(b_plus, unique_parent_id, self.vms_dict[key]['VMName'], 
					self.vms_dict[key]['VMName'], self.vms_dict[key]['guid'], 
					self.vms_dict[key]['HealthState'], self.vms_dict[key]['PowerState'], 
					switch)

			
	return '<ul class="tree_ul">'+tree_html+'</ul>'
    
    
    def detach_vm(self, data):
        
        logging.info('Hypervisor - win Switch Configuration detach Vm : Sid : %s, Ip : %s, name_label : %s, vmid : %s'%( self.sid, self.ip, data['name_label'], data['vmid']))
        self.mainObj = VM_Summary()
        status = self.mainObj.DetachVNFromVM(self.sid, self.ip, data['name_label'], data['vmid'])
        logging.info('Hypervisor - win Switch detach vm status : %s'%( status ))
        
        if status == 0 or status == -2:
            return  status
        else:
            return -1
