from UmBoostLib import VMsList, win_VMList, winVSwitchList, winSwitchList,  VM_Summary
import settings, simplejson
logging = settings.get_logger()

class WinVirtualNetworkSettings(object):
    
    def __init__(self, sid, ip, type):
        self.sid = sid
        self.ip = ip
        self.type = type
    
    def get_initial_data(self):
        
        self.return_data = {}
        self.list_vms()
        self.list_networks()
        return simplejson.dumps(self.return_data)

    def list_vms(self):
        
        self.agmtVMListObj = win_VMList()
        self.mainwinVMsListObj = VMsList()
        
        logging.info('Hypervisor - win VNS Configuration List VMs sid : %s , IP : %s'%(self.sid, self.ip))
        status = self.mainwinVMsListObj.ListVMs(self.agmtVMListObj, self.sid, self.ip)
        logging.info('Hypervisor - win VNS Configuration List VMs status: %s'%status)
        
        if status == 0:
            html = '<select>'
            for i in range(len(self.agmtVMListObj)):
                html += '<option value="%s">%s</option>'%( self.mainwinVMsListObj.get(self.agmtVMListObj,i).guid, self.mainwinVMsListObj.get(self.agmtVMListObj,i).VMName )
            
                '''vSwGuid = self.mainwinVMsListObj.get(self.agmtVMListObj,i).vSwGuid.strip()
                if vSwGuid != '':
                    self.vms_dict[vSwGuid] = current_vms_dict'''
            
            html += '</select>'

            self.return_data['vm_status'] = '0'
            self.return_data['vm_html'] = html
        elif status == -2:
            self.return_data['vm_status'] = '-2'
        else:
            self.return_data['vm_status'] = '-1'
    def get_vnic_data(self,vm_guid):
	self.return_data = {}
	self.list_vms()
	for i in range(len(self.agmtVMListObj)):
		
		if self.mainwinVMsListObj.get(self.agmtVMListObj,i).guid == vm_guid:
			html = '<select>'
			html += '<option value="null">Select one</option>'%()
			mac_data = self.mainwinVMsListObj.get(self.agmtVMListObj,i).vNicList
			mac_list = mac_data.split(',');
			for i in mac_list: 
				html += '<option value="%s">%s</option>'%(i,i)
			html += '</select>'
		
		
		
	self.return_data['vnic_status'] = 0
	self.return_data['vnic_html'] = html
	return simplejson.dumps(self.return_data)
        
    
    def list_networks(self):
        
        logging.info('Hypervisor - win VNS Configuration List Networks : Sid : %s, Ip : %s'%( self.sid, self.ip ))
        self.mainwinSwitchListobj = winVSwitchList()
        self.agmtSwitchListobj = winSwitchList()
        status = self.mainwinSwitchListobj.ListvNetworks( self.agmtSwitchListobj, self.sid, self.ip )
        logging.info('Hypervisor - win VNS Configuration List Networks status : %s'%( status ))
        
        if status == 0:
            html = '<select>'
            for i in range(len(self.agmtSwitchListobj)):
                html += '<option value="%s">%s</option>'%( self.mainwinSwitchListobj.get(self.agmtSwitchListobj,i).guid, self.mainwinSwitchListobj.get(self.agmtSwitchListobj,i).vSwitchName )
            
                '''vSwGuid = self.mainwinVMsListObj.get(self.agmtVMListObj,i).vSwGuid.strip()
                if vSwGuid != '':
                    self.vms_dict[vSwGuid] = current_vms_dict'''
            
            html += '</select>'
            self.return_data['nw_status'] = '0'
            self.return_data['nw_html'] = html
        elif status == -2:
            self.return_data['nw_status'] = '-2'
        else:
            self.return_data['nw_status'] = '-1'

    def attach_VnwToVM(self, data):
       
        logging.info('Hypervisor - win VNS attach : Sid : %s, Ip : %s, VM Id: %s, NW Id : %s'%( self.sid, self.ip, data['nw_id'], data['vm_id']))
        Obj = VM_Summary()
        status = Obj.AttachVNToVM( self.sid, self.ip, data['nw_id'], data['vm_id'], data['vnic_id'])
        logging.info('Hypervisor - win VNS attach status : %s'%( status ))
        
        if status == 0 or status == -2:
            return status
        else:
            return -1
          
