from UmBoostLib import WDirect, WdList, WdParamsList
import simplejson
 
import settings
logging = settings.get_logger()

class WdudpClass:
    
    def __init__(self, sid , ip, req_type):
        self.sid = sid
        self.ip = ip
        self.req_type = req_type

    def get_processes(self):
        
        logging.info('Wdudp get processes - waiting for response from UMboost sid : %s , IP : %s'%(self.sid,self.ip))
        self.mainObj = WDirect()
        status = self.mainObj.getPidsOfWd(self.sid, self.ip, 0)
        logging.info('Wdudp get processes status : %s'%(status))
        
        if status == 0:
            logging.info('Wdudp process ids : %s'%self.mainObj.pidsBuf)
            pids = self.mainObj.pidsBuf.strip()
            if pids != '':
                return self.generateProcessesHtml(pids)
            else:
                return -1
        elif status == -2:
            return -2
        else:
            return -1     
        
    def generateProcessesHtml(self, pids):
        ip_id = self.ip.replace('.','_')
        unique_parent_id = '#wiredirect_content__incend__'+ ip_id +' .wdudp_stats_attrs_tab';
        html = '<select class="processes" onchange="wdudp_load_stats_attr(\'%s\', \'%s\', $(this))">\
                    <option value="">Select One..</option>%s\
                </select>'
                
        pids_list = pids.split(',')
        
        if len(pids_list) > 1:        
            html_list = [ '<option value="%s">%s</option>'%( i, i ) for i in pids_list ]
            return html%( unique_parent_id, ip_id, ''.join(html_list) )
        else:
            return html%(unique_parent_id, ip_id, '<option value="'+pids_list[0]+'">'+pids_list[0]+'</option>')
            
    def load_stats_attrs(self, pid):
        
        data = {}
        data['stats'] = self.getStats(pid)
        data['attrs'] = self.getAttrs(pid)
        return simplejson.dumps(data) 
    
    def getStats(self, pid):
        
        logging.info('Wdudp get Statistics - waiting for response from UMboost sid : %s , IP : %s, Pid : %s'%(self.sid, self.ip, pid))
        self.agmtStatsObj = WdParamsList()
        self.mainStatsObj = WdList()
        status = self.mainStatsObj.getWdStats(self.agmtStatsObj, self.sid, self.ip, int(pid), 0)
        logging.info('Wdudp get Statistics status : %s'%(status))
        
        if status == 0:
            return self.generateStatsHtml()
        elif status == -2:
            return status
        else:
            return -1   
        
    def generateStatsHtml(self):
        
        html = '<div class="child_div clear grid-a center">\
                    <div class="ui-block-a ui-blocks f_bold">%s</div>\
                    <div class="ui-block-a ui-blocks bg_none">%s</div>\
                </div>'
                
        html_list = []
        #This is a dummy loop , it always runs only once.         
        for i in range(0,len(self.agmtStatsObj)):
             html_list.append(html%('Fast Sends', self.mainStatsObj.get(self.agmtStatsObj,i).fastsends))
             html_list.append(html%('Slow Sends', self.mainStatsObj.get(self.agmtStatsObj,i).slowsends))
             html_list.append(html%('Fast Recvs', self.mainStatsObj.get(self.agmtStatsObj,i).fastrcvs))
             html_list.append(html%('Slow Recvs', self.mainStatsObj.get(self.agmtStatsObj,i).slowrcvs))
             html_list.append(html%('Waits', self.mainStatsObj.get(self.agmtStatsObj,i).waits))
             html_list.append(html%('QP TX Packets', self.mainStatsObj.get(self.agmtStatsObj,i).txpkts))
             html_list.append(html%('QP TX Bytes', self.mainStatsObj.get(self.agmtStatsObj,i).txbytes))
             html_list.append(html%('QP RX Packets', self.mainStatsObj.get(self.agmtStatsObj,i).rxpkts))
             html_list.append(html%('QP RX Bytes', self.mainStatsObj.get(self.agmtStatsObj,i).rxbytes))
             
        return ''.join(html_list)
    
    def getAttrs(self, pid):
        
        logging.info('Wdudp get Attributes - waiting for response from UMboost sid : %s , IP : %s, Pid : %s'%(self.sid, self.ip, pid))
        self.agmtStatsObj = WdParamsList()
        self.mainStatsObj = WdList()
        status = self.mainStatsObj.getWdAttributes(self.agmtStatsObj, self.sid, self.ip, int(pid), 0)
        logging.info('Wdudp get Attributes status : %s'%(status))
        
        if status == 0:
            return self.generateAttrsHtml()
        elif status == -2:
            return status
        else:
            return -1
    
    def generateAttrsHtml(self):
        
        html = '<div class="child_div clear grid-a center">\
                    <div class="ui-block-a ui-blocks f_bold">%s</div>\
                    <div class="ui-block-a ui-blocks bg_none">%s</div>\
                </div>'
                
        html_list = []        
        for i in range(0,len(self.agmtStatsObj)):
             html_list.append(html%('QP Number', self.mainStatsObj.get(self.agmtStatsObj,i).qpnum))
             html_list.append(html%('Sockfd', self.mainStatsObj.get(self.agmtStatsObj,i).sockfd))
             html_list.append(html%('State', self.mainStatsObj.get(self.agmtStatsObj,i).state))
             html_list.append(html%('Device', self.mainStatsObj.get(self.agmtStatsObj,i).device))
             html_list.append(html%('Device Address', self.mainStatsObj.get(self.agmtStatsObj,i).devaddr))
             html_list.append(html%('Filter ID', self.mainStatsObj.get(self.agmtStatsObj,i).fid))
             html_list.append(html%('Local Address', self.mainStatsObj.get(self.agmtStatsObj,i).laddr))
             html_list.append(html%('Remote Address', self.mainStatsObj.get(self.agmtStatsObj,i).raddr))
             html_list.append(html%('VLAN', self.mainStatsObj.get(self.agmtStatsObj,i).vlan))
             html_list.append(html%('Priority', self.mainStatsObj.get(self.agmtStatsObj,i).prio))
             
        return ''.join(html_list)        
