from UmBoostLib import ApList, AppList

import logging, simplejson
import settings
logging.basicConfig(filename=settings.log_path,level=logging.DEBUG)

class UwmComponentVersion:

    def __init__(self,sessionId,hostIP) :
         self.sessionId=sessionId
         self.hostIP=hostIP
         self.boostComponentVersionObj=ApList()
         self.boostAppListobj = AppList()

    def getVersionList(self):
        logging.info('UwmComponentVersion :  waiting for response from UMboost sid : %s , IP : %s'%(self.sessionId,self.hostIP))
        status=self.boostAppListobj.getAppVerInfo(self.boostComponentVersionObj,self.sessionId,self.hostIP)
        logging.info('UwmComponentVersion status: %s'%status)
        
        if status == 0:
          return self.generateHTML()
        elif status == -2:
          return -2
        else:
          return -1

    def getItems(self):
        for i in range (0,len(self.boostComponentVersionObj)):
          yield self.boostAppListobj.get(self.boostComponentVersionObj,i)

    def generateHTML(self):
        
        top_html = '<ul class="horizontal content_tbl clear from_server">\
                    <li class="label">%s&nbsp;</li>'
        bottom_html = '<li class="bg_none versions" >%s&nbsp;</li></ul>'
        
        whole_html = '%s%s'
        
        html_list = []
        height = 30
        for i in self.getItems():
            html_list.append( whole_html%( top_html %  i.Name , bottom_html %  i.Ver ) )
            height += 33
        
        data = {}
        data['height'] = height
        data['html'] = ''.join(html_list)
        return simplejson.dumps(data)
