from UmBoostLib import VersionInfoList as vermagic
from xml.dom.minidom import Document as XML

## The instance of the VersionInfo class
class VersionInfo:
    ##Constructor for the class VersionInfo
    ##@param sessionId
    # The session identifier.
    ##@param hostIP
    # The IP of the machine whose details are to be fetched.
    def __init__(self,sessionId,hostIP):
        self.sessionId = sessionId
        self.hostIP = hostIP
        self.ver = vermagic()

    ## Gets the versions of all the Libraries and the server.
    ##@return
    # Returns the xml data-set.
    def getVersions(self):
        xmlContent = ""
        status = self.ver.GetVersion(self.sessionId,self.hostIP)
        if ( status != 0 ):
            return "Unknown Error"
        else :
            xmlContent = self.generateXML()
            return xmlContent

    ## Generator function for all the version listing.
    ##@return
    # Returns the iter element of the type VersionInfo
    def getItems(self):
        for i in range(0,len(self.ver)):
            yield self.ver.getitem(i)

    ## Generates the XML data-set for rendering the data.
    ##@return
    # Returns the XML data-set.
    def generateXML(self):
        doc = XML()
        wml = doc.createElement("VersionInfo")
        doc.appendChild(wml)
        for i in self.getItems() :
            IP = doc.createElement("IP")
            wml.appendChild(host)
            # set attr here
            keyName = doc.createElement("KeyName")
            IP.appendChild(keyName)
            keyNameText = doc.createTextNode(i.Name)
            keyName.appendChild(keyNameText)
            ver = doc.createElement("Version")
            IP.appendChild(ver)
            verText = doc.createTextNode(str(i.ver))
            ver.appendChild(verText)
        strn = doc.toprettyxml(indent="  ", encoding = "UTF-8")
        return strn
