from UmBoostLib import TrafficMgmt, PrimitiveList, PrimList, Policy_Action
from Constants import TM_CONGESTION
import simplejson, settings
logging = settings.get_logger()

class TrafficManagement:
    
    def __init__(self, sid, ip, req_type):
         self.sid = sid
         self.ip = ip
         self.req_type = req_type
    
    def get_rules_list(self, ifName, chiptype):
       self.boostTMobj = TrafficMgmt()
       logging.info('Traffic Management Get Rules List: SID : %s, IP : %s , Ifname : %s, chiptype : %s '%( self.sid, self.ip, ifName, chiptype ))
       status = self.boostTMobj.getOfldPolicies(self.sid, self.ip, ifName, chiptype)
       logging.info('Traffic Management Get Rules List status: %s'%(status))
       
       if status == 0:
           return self.generate_rules_list_html(self.boostTMobj.nPolicies)
       elif status == -2 or status == 243:
           return status
       else:
           return -1
       
    def generate_rules_list_html(self, policies_count):
        ip_id = self.ip.replace('.','_')
        
        if self.req_type == 'desktop':
            unique_parent_id = '#traffic_manage_content__incend__%s .traffic_management_c_tab'%(ip_id)
        else:
            unique_parent_id = '#tmc__%s__incend'%ip_id
        
        html = [ '<li class="hover_li" onclick="tm_policy_select(\'%s\', $(this), %s, \'%s\')" ><span class="rule_str">%s</span>\
                  <input type="hidden" value="%s" class="idx" /></li>'%(
                                                                       unique_parent_id,
                                                                       i,
                                                                       self.ip, 
                                                                       self.boostTMobj.getPolicyString(i),
                                                                       i
                                                                       ) for i in range(0,policies_count) ]
        return ''.join(html)
    
    def get_rule_details(self, index, ifName, chiptype):
        self.boostPLobj = PrimList()
        self.boostPRLobj = PrimitiveList()
        boostPAobj = Policy_Action()
        
        self.boostTMobj = TrafficMgmt()
        logging.info('Traffic Management Get Rules List: SID : %s, IP : %s , Ifname : %s, chiptype : %s '%( self.sid, self.ip, ifName, chiptype ))
        status = self.boostTMobj.getOfldPolicies(self.sid, self.ip, ifName, chiptype)
        logging.info('Traffic Management Get Rules List status: %s'%(status))
        
        logging.info('Traffic Management Get Rule Details: Index : %s '%( index ))
        status = self.boostPRLobj.ListPrimitive(self.boostPLobj, self.boostTMobj, int(index))
        logging.info('Traffic Management Get Rule Details: status :  %s '%( status ))
        
        logging.info('Traffic Management Get Actions Details: Index : %s '%( index ))
        status = boostPAobj.getPolicyAction(self.boostTMobj, int(index))
        logging.info('Traffic Management Get Actions Details: status :  %s '%( status ))
        
        if status == 0:
            data = {}
            data['html'] = self.generate_rules_detail_html(index)
            data['offload'] = boostPAobj.offload
            data['ddp'] = boostPAobj.ddp
            data['tstamp'] = boostPAobj.tstamp
            data['sack'] = int(boostPAobj.sack)
            data['bind_q'] = boostPAobj.bind_q
            data['class_v'] = boostPAobj.sched_class
            cong = int(boostPAobj.cong_algo)
            if cong >= 0 and cong <= 3:
                data['congestion'] = TM_CONGESTION[cong]
            else:
                data['congestion'] = -1 
            logging.info('sack : %s'%int(boostPAobj.sack))
            logging.info('bind_q : %s'%boostPAobj.bind_q)
            logging.info('class : %s'%boostPAobj.sched_class)
            logging.info('congestion : %s'%cong)
            return simplejson.dumps(data)
        elif status == -2:
            return -2
        else:
            return -1
        
    def generate_rules_detail_html(self, index):
        ip_id = self.ip.replace('.','_')
        
        if self.req_type == 'desktop':
            unique_parent_id = '#traffic_manage_content__incend__%s .traffic_management_c_tab'%(ip_id)
        else:
            unique_parent_id = '#tmc__%s__incend'%ip_id
        
        function_name = 'tm_rule_select(\'%s\', $(this))'%unique_parent_id
        rule_detail_li = ''
        
        for i in range(0,len(self.boostPLobj)):
            
            rule_detail_li += '<li class="hover_li" onclick="%s">'%function_name
            rule_detail = ''
            
            type = self.boostPRLobj.get(self.boostPLobj,i).type
            logging.info('Type : %s'%type)
            
            if self.boostPRLobj.get(self.boostPLobj,i).srcdst == 1:
                rule_detail = 'src'
                rule_detail_li += '<input type="hidden" value="1" class="qualifier" />'
            elif self.boostPRLobj.get(self.boostPLobj,i).srcdst == 2:
                rule_detail = 'dst'
                rule_detail_li += '<input type="hidden" value="2" class="qualifier" />' 
            elif self.boostPRLobj.get(self.boostPLobj,i).srcdst == 3:
                rule_detail = 'src and dst'
                rule_detail_li += '<input type="hidden" value="3" class="qualifier" />'
            elif self.boostPRLobj.get(self.boostPLobj,i).srcdst == 4:
                rule_detail = 'src or dst' 
                rule_detail_li += '<input type="hidden" value="4" class="qualifier" />'
            
            if type == 13:
                rule_detail += ' port '
                rule_detail_li += '<input type="hidden" value="13" class="expression" />'
            elif type == 17:
                rule_detail += ' aopen '
                rule_detail_li += '<input type="hidden" value="17" class="expression" />' 
            elif type == 18:
                rule_detail += ' popen '
                rule_detail_li += '<input type="hidden" value="18" class="expression" />'
            elif type == 19:
                rule_detail += ' mark ' 
                rule_detail_li += '<input type="hidden" value="19" class="expression" />'
            elif type == 30:
                rule_detail += ' net ' 
                rule_detail_li += '<input type="hidden" value="30" class="expression" />'
            elif type == 1073751171:
                rule_detail += ' vers ' 
                rule_detail_li += '<input type="hidden" value="1073751171" class="expression" />'
            elif type == 16:
                rule_detail += ' listen ' 
                rule_detail_li += '<input type="hidden" value="16" class="expression" />'
            elif type == 15 or type == 1073751691:
                rule_detail += ' vlan ' 
                rule_detail_li += '<input type="hidden" value="15" class="expression" />'
            elif type == 1073751301:
                rule_detail += ' dscp ' 
                rule_detail_li += '<input type="hidden" value="1073751301" class="expression" />'
            elif type == 1073751303:
                rule_detail += ' tos ' 
                rule_detail_li += '<input type="hidden" value="1073751303" class="expression" />'
            elif type == 10:
                rule_detail += ' host ' 
                rule_detail_li += '<input type="hidden" value="10" class="expression" />'
                
            exp_val = self.boostPRLobj.get(self.boostPLobj,i).value
            rule_detail_li += '<input type="hidden" value="%s" class="value" />'%exp_val
            rule_detail += ' %s'%exp_val
            
            if self.boostPRLobj.get(self.boostPLobj,i).connToNextPrim == 1:
                rule_detail_li += '<span class="rule_str">'+rule_detail+'</span><input type="hidden" value="0" class="operator" /></li>'
                rule_detail_li += '<li class="hover_li" onclick="%s"><input type="hidden" value="1" class="operator" />and</li>'%function_name
            elif self.boostPRLobj.get(self.boostPLobj,i).connToNextPrim == 2:
                rule_detail_li += '<span class="rule_str">'+rule_detail+'</span><input type="hidden" value="0" class="operator" /></li>'
                rule_detail_li += '<li class="hover_li" onclick="%s"><input type="hidden" value="2" class="operator" />or</li>'%function_name
            elif self.boostPRLobj.get(self.boostPLobj,i).connToNextPrim == 3:
                rule_detail_li += '<span class="rule_str">'+rule_detail+'</span><input type="hidden" value="0" class="operator" /></li>'
            else:
                rule_detail_li += '<span class="rule_str">'+rule_detail+'</span><input type="hidden" value="0" class="operator" /></li>'
        return rule_detail_li
    
    def update_rule(self, data):
        
        self.boostTMobj = TrafficMgmt()
        logging.info('Traffic Management Update Rule - SID : %s, IP : %s , idx : %s, ifName : %s , policy : %s , reqType : %s\
                     '%( self.sid, self.ip, data['idx'], data['ifName'], data['policy'], data['reqType']))
        status = self.boostTMobj.AddDelModifyPolicy( self.sid, self.ip, int(data['idx']), data['ifName'], data['policy'], int(data['reqType']) )
        logging.info('Traffic Management Update Rule status: %s'%(status))
        
        if status == 0 or status == -2 or status == 408:
            return status
        else:
            return -1
        