from UmBoostLib import SysSummary
import settings, simplejson
import logging
logging.basicConfig(filename=settings.log_path,level=logging.DEBUG)

class SystemDiagnostics:
    def __init__(self, sid, ip, req_type):
        self.sid = sid
        self.ip = ip
        self.req_type = req_type
        self.testObj = SysSummary()
        
    def performTest(self, data):
        
        self.card_results = {}
        self.adapIdx = data['card_str']
        self.sel_cards =  self.adapIdx.split(',')
        self.total_cards = data['total_cards']
        self.card_names = data['card_names'].split(',')
        full_tests = range(5)
        self.tests = data['operation_str'].split(',')
        
        #Looping through all tests
        for i in full_tests:
            #Running tests only for the selected tests
            if str(i) in self.tests:
                status = self.runTest(i)
                if status == -2 or status == -1:
                    return status
                else:
                    results = status.split(';')
                    for j in results:
                        if j.strip() != '':
                            card_idx = j.split(',')[0].strip()
                            self.card_results["%s__%s"%(card_idx, i)] = j.split(',')[1].strip()
            else:
                #Adding dummy result for all the cards for this test
                #Adding null results for all the remaining not selected tests , if all the cards are selected
                if self.adapIdx == 'all':
                    for j in range(int(self.total_cards)):
                        self.card_results["%s__%s"%(j,i)] = '-'
                else:
                    #Adding dummy result for all the cards for this test
                    for j in self.sel_cards:
                        self.card_results["%s__%s"%(j,i)] = '-'
        
        logging.info('System Diagnostics Final Result Dict : %s'%self.card_results)
        return simplejson.dumps(self.generateHtml())

    def runTest(self, diagType):
        
        logging.info('System Diagnostics run test Waiting for Boost - sid :%s, ip :%s, adapIdx :%s, diagType :%s'%(self.sid, self.ip, self.adapIdx, diagType))
        status = self.testObj.RunHBADiagnostics(self.sid, self.ip, str(self.adapIdx), int(diagType))
        logging.info('System Diagnostics Result, Status : %s'%status)
        if status.strip() == '':
            status = -1
        return status
    
    def generateHtml(self):
        
        def getCssClass(data):
            if data.strip() == '0':
                return 'Success'
            elif data.strip() == '1':
                return 'Failed'
            else:
                return data.strip()
            
        height = 315
        html_list = []
        
        if self.req_type == 'desktop':
            html_list.append('<ul class="horizontal head_ul">\
                            <li class="tests"><h2>Card</h2></li>\
                            <li class="tests"><h2>LED</h2></li>\
                            <li class="cr"><h2>Control Registers</h2></li>\
                            <li class="tests"><h2>MII Registers</h2></li>\
                            <li class="tests"><h2>EEPROM</h2></li>\
                            <li class="im"><h2 class="bg_none">Internal Memory</h2></li>\
                        </ul>')
    
            data_html = '<ul class="horizontal content_tbl clear_left">\
                            <li class="tests">%s</li>\
                            <li class="tests %s">%s</li>\
                            <li class="cr %s">%s</li>\
                            <li class="tests %s">%s</li>\
                            <li class="tests %s">%s</li>\
                            <li class="im %s">%s</li>\
                        </ul>'
        else:
            html_list.append('<div class="ui-grid-a ui-bar-b">\
                                <div class="ui-block-a">\
                                    <div class="ui-grid-b pdn_5_0">\
                                        <div class="ui-block-a center">CARD</div>\
                                        <div class="ui-block-b center">LED</div>\
                                        <div class="ui-block-c center">CONTROL REGISTERS</div>\
                                    </div>\
                                </div>\
                                <div class="ui-block-b ">\
                                    <div class="ui-grid-b pdn_5_0">\
                                        <div class="ui-block-a center">MII REGISTERS</div>\
                                        <div class="ui-block-b center">EEPROM</div>\
                                        <div class="ui-block-c center bg_none">INTERNAL MEMORY</div>\
                                    </div>\
                                </div>\
                            </div>')
            
            data_html = '<div class="ui-grid-a">\
                            <div class="ui-block-a">\
                                <div class="ui-grid-b detail pdn_5_0">\
                                    <div class="ui-block-a center">%s</div>\
                                    <div class="ui-block-b center %s">%s</div>\
                                    <div class="ui-block-c center %s">%s</div>\
                                </div>\
                            </div>\
                            <div class="ui-block-b">\
                                <div class="ui-grid-b detail pdn_5_0">\
                                    <div class="ui-block-a center %s">%s</div>\
                                    <div class="ui-block-b center %s">%s</div>\
                                    <div class="ui-block-c center bg_none %s">%s</div>\
                                </div>\
                            </div>\
                        </div>'
        
        
        if self.adapIdx == 'all':
            for i in range(int(self.total_cards)):
                height += 39
                html_list.append( data_html%( self.card_names[i], getCssClass(self.card_results["%s__%s"%(i,0)]).lower(), getCssClass(self.card_results["%s__%s"%(i,0)]),\
                                              getCssClass(self.card_results["%s__%s"%(i,1)]).lower(), getCssClass(self.card_results["%s__%s"%(i,1)]),\
                                              getCssClass(self.card_results["%s__%s"%(i,2)]).lower(), getCssClass(self.card_results["%s__%s"%(i,2)]),\
                                              getCssClass(self.card_results["%s__%s"%(i,3)]).lower(), getCssClass(self.card_results["%s__%s"%(i,3)]),\
                                              getCssClass(self.card_results["%s__%s"%(i,4)]).lower(), getCssClass(self.card_results["%s__%s"%(i,4)])))
        else:
            #Adding dummy result for all the cards for this test
            j = 0
            for i in self.sel_cards:
                i = int(i)
                height += 39
                html_list.append( data_html%( self.card_names[j], getCssClass(self.card_results["%s__%s"%(i,0)]).lower(), getCssClass(self.card_results["%s__%s"%(i,0)]),\
                                              getCssClass(self.card_results["%s__%s"%(i,1)]).lower(), getCssClass(self.card_results["%s__%s"%(i,1)]),\
                                              getCssClass(self.card_results["%s__%s"%(i,2)]).lower(), getCssClass(self.card_results["%s__%s"%(i,2)]),\
                                              getCssClass(self.card_results["%s__%s"%(i,3)]).lower(), getCssClass(self.card_results["%s__%s"%(i,3)]),\
                                              getCssClass(self.card_results["%s__%s"%(i,4)]).lower(), getCssClass(self.card_results["%s__%s"%(i,4)])))
                j = j + 1
        
        return_data = {}  
        return_data['height'] = height
        return_data['html'] = ''.join(html_list)  
        return return_data