from UmBoostLib import logList, MessageLog

import settings
logging = settings.get_logger()

class SystemAppLogs:
    
    def __init__(self, sid, ip, from_range, type):
        self.sid = sid
        self.ip = ip  
        self.from_range = from_range
        self.type = type
        self.boostLogObj = logList()
        self.boostMLogObj = MessageLog()

    def get_systemapplogs(self):
        
        logging.info('system App Logs , Waiting to get response from umboost; Ags Passed: sid: %s ; Ip : %s , From : %s'%(self.sid, self.ip, self.from_range))
        status = self.boostMLogObj.getMessageLogs(self.boostLogObj, self.sid, self.ip, self.from_range)
        logging.info('system App Logs status: %s ' %status)

        if status == 0:
            return self.generate_html()
        #status == 4 -  ERR_NO_LOGS - refer PR#16376
        elif status == -2 or status == 4:
            return status
        else:
            return -1
        
        
    def get_obj(self):
        for i in range(0,len(self.boostLogObj)):
            j = i+1
            yield j ,self.boostMLogObj.get(self.boostLogObj, i)

    def generate_html(self):
        
        if self.type == 'desktop':
           grid_head_html = '<div class="horizontal head_ul grid-a">\
                                <div class="sno ui-block-a ui-blocks"><h2>Sno</h2></div>\
                                <div class="entry ui-block-b ui-blocks"><h2 class="bg_none">Log Entry</h2></div>\
                             </div>'
           logs_html = '<div class="horizontal content_tbl clear grid-a">\
                            <div class="label sno ui-block-a ui-blocks">%s&nbsp;</div>\
                            <div class="entry ui-block-b ui-blocks">%s&nbsp;</div>\
                            </div>'
        else:
            grid_head_html = '<div class="ui-grid-a heading" data-theme="b" >\
                                <div class="ui-block-a ui-bar-b center sno">SNO</div>\
                                <div class="ui-block-b ui-bar-b center log">Log Entry</div>\
                             </div>'
            logs_html = '<div class=" ui-grid-a grid">\
                            <div class="ui-block-a iter sno">%s&nbsp;</div>\
                            <div class="ui-block-b iter log" >%s&nbsp;</div>\
                            </div>'
        
        html_list = [ logs_html%( i , j.Message  ) for i,j in self.get_obj() ]
        
        html = ''.join(html_list)
        return grid_head_html + html
    
    
    def delete_applogs(self):
        
        logging.info('system App Logs , Delete Logs - sid: %s ; Ip : %s'%(self.sid, self.ip))
        status = self.boostMLogObj.clearMessageLogs(self.sid, self.ip)
        logging.info('system App Logs, Delete Logs status: %s ' %status)

        if status == 0 or status == -2:
            return status
        else:
            return -1