#From Python
from xml.dom.minidom import Document as XML
import os

#From Project
from UmBoostLib import MgmtStationLogin as localStation
import settings
logging = settings.get_logger()

class StationLogin:
    
    def __init__(self,user,password,sessionId):
        self.name = user
        self.password = password
        self.sessionId = sessionId
        self.login = localStation()

    ## Authenticates the user credentials
    def authenticate(self):
        
        status = self.get_mgmt_license_status()
        if status == -12:
            return -12
        
        logging.info('Trying to login - waiting for the response from umboost : Ags passed: username : %s , password : %s , sid : %s '%(self.name,self.password,self.sessionId))
        status = self.login.Login(self.name,self.password,self.sessionId)
        logging.info('Final login result: %s'%status)
        
        if status == 0:
            return self.generateXML(status)
        elif status == -7 or status == -11:
            return status
        else:
            return -1
        
    def get_mgmt_license_status(self):
        logging.info('Get the License status of Mgmt')
        status = self.login.getMgmtStationLicense('')
        logging.info('Get the License status of Mgmt result: %s'%status)
        
        if status == -12 or status == 0:
            return status
        else:
            return -1
        
    def upload_mgmt_license_key(self, data):
        logging.info('LicenseMgmtStation : keyPath : %s'%data['keyPath'])
        status = self.login.LicenseMgmtStation('', data['keyPath'])
        logging.info('LicenseMgmtStation status : %s'%status)
        
        if status == 0:
            return self.generateXML(status)
        else:
            return self.generateXML(-1)

    ## Logs the user out.
    def logout(self):
        logging.info('Requesting for logout , waiting for boost response: Ags Passed: sid : %s'%self.sessionId)
        status = self.login.Logout(self.sessionId)
        logging.info('Final logout result: %s'%status)
        return status

    def generateXML(self,status):
        strn = '<?xml version="1.0" encoding="UTF-8"?>'
        strn += "<session sID=\""
        strn += self.sessionId
        strn += "\"><login><status>"
        strn += str(status)
        strn += "</status></login>"
        strn += "</session>"
        return strn