from UmBoostLib import PList, PropsList
from xml.dom.minidom import Document
import simplejson

import logging
import settings
logging.basicConfig(filename=settings.log_path,level=logging.DEBUG)

class PortStatistics:
    
    def __init__(self, session_id ,ip , pciloc , index ):
        self.session_id = session_id
        self.ip = ip
        self.pciloc = pciloc
        self.index = index
        self.boostStatsObj = PList()
        self.boostPropsObj = PropsList()

    def get_port_statistics(self):
        
        logging.info('Port Statistics:  waiting for response from UMboost sid : %s , IP : %s , PCILOC : %s , Index : %s'%(self.session_id,self.ip,self.pciloc,self.index))
        status = self.boostPropsObj.getPortStats(self.boostStatsObj,self.session_id,self.ip,self.pciloc,str(self.index))
        logging.info('Port Statistics status: %s'%status)
        
        if status == 0:
            return self.generateHTML()
        elif status == -2 or status == 69:
            return status
        else:
            return -1
        
    def getItems(self):
        for i in range(0,len(self.boostStatsObj)):
            yield self.boostPropsObj.get(self.boostStatsObj,i)    

    def generateHTML(self):
        
        height = 41
        head_html = '<ul class="horizontal head_ul">\
                        <li><h2>Statistic</h2></li>\
                        <li><h2 class="bg_none" >Value</h2></li>\
                     </ul>'
        
        top_html = '<ul class="horizontal content_tbl clear from_server">\
                    <li class="label">%s</li>'
        bottom_html = '<li class="bg_none port_stats_rec" >%s</li></ul>'
    
        whole_html = '%s%s'
        html_list = []
        for i in self.getItems():
            html_list.append(whole_html%( top_html %  i.propName , bottom_html %  i.value ))
            height += 32
    
        html = ''.join(html_list)
        data = {}
        data['html'] = head_html + html
        data['height'] = height 
        return simplejson.dumps(data)
