from UmBoostLib import UMOsInfo as osInfo
from xml.dom.minidom import Document as XML

## Instance of the os info class
class OsInfo:
    ##Constructor for the class OsInfo
    ##@param sessionId
    # The session identifier.
    ##@param hostIP
    # The host IP
    def __init__(self,sessionId,hostIP):
        self.sessionId = sessionId
        self.hostIP = hostIP
        self.OsInfo = osInfo()

    ## Gets the os and arch information of the host node
    ##@return
    # Returns the xml data-set of the os information
    def getOsInfo(self):
        xmlContent = ""
        status = self.OsInfo.GetOsInfo(self.sessionId,self.hostIP)
        if ( status != 0 ):
            return "unknown error"
        else :
            xmlContent = self.generateXML()
            return xmlContent

    ## Generates the xml data-set
    ##@return
    # Returns the data-set in XML format that is used in rendering the same.
    def generateXML(self):
        doc = XML()
        wml = doc.createElement("OSInfo")
        doc.appendChild(wml)
        for i in self.getItems() :
            host = doc.createElement("host")
            wml.appendChild(host)
            osType = doc.createElement("OSType")
            host.appendChild(osType)
            hostOsText = doc.createTextNode(i.hostOs)
            osType.appendChild(hostOsText)
            arch = doc.createElement("Arch")
            host.appendChild(arch)
            archText = doc.createTextNode(i.arch)
            arch.appendChild(archText)
        strn = doc.toprettyxml(indent="  ", encoding = "UTF-8")
        return strn

    def getSystemSummary(self):
	xmlContent = ""
	status = GetSystemSummary(self.sessionId,self.hostIP)
	##@note
	# var HostName, HostIp, str(Port),str( CardCount), str(isLicesnseValid), PlatArch, HostOsName
