from UmBoostLib import PingOrTraceRoute, TraceList, TraList
import utils
import logging, time, simplejson
import settings
logging.basicConfig(filename=settings.log_path,level=logging.DEBUG)

class PingTraceRoute:
    
    def __init__(self,sessionId,hostIP):
        self.sessionId = sessionId
        self.hostIP = hostIP

    def ping_traceroute_actions(self,data):
        
        if data['action'] == 'ping_set' or data['action'] == 'traceroute_initiate':
            
            try:
                is_ip = int(data['ip'][0])
                logging.info('Validate IP : %s, Validate : 1 '%data['ip'])
                ip_validate = utils.validate_ip(data['ip'], 1)
                logging.info('IP Validate status %s'%ip_validate)
                if ip_validate == -1:
                    return  '-5'
            except:
                pass
                
        logging.info('%s:  waiting for response from UMboost sid : %s , IP : %s\
                    reqType : %s , ip : %s ,  numpkts : %s , timeout :%s\
                    '%(data['action'],self.sessionId,self.hostIP,data['reqType'],data['ip'],data['numpkts'],data['timeout']))
        self.boostPingTraceRouteObj = PingOrTraceRoute()
        status = self.boostPingTraceRouteObj.SetGetPingTraceRoute(self.sessionId,self.hostIP,int(data['reqType']),data['ip'],data['numpkts'],data['timeout'])
        logging.info('%s status: %s'%(data['action'],status))
        
        if status == 0:
            if data['action'] == 'ping_result':
                return self.get_ping_results()
            else:
                return status
        elif status == -2:
            return -2
        else:
            return -1
        
    def get_ping_results(self):
        ptks_send = 'Pkts Send: %s , '%self.boostPingTraceRouteObj.pktsSent
        ptks_recvd = 'Pkts Recvd: %s , '%self.boostPingTraceRouteObj.pktsRcvd
        avgrtt = 'AVgRtt: %s ms'%self.boostPingTraceRouteObj.avgRtt
        whole_result  = "%s%s%s"%( ptks_send, ptks_recvd, avgrtt )
        return whole_result
    
    def traceroute_result(self, data):
        self.req_type = data['req_type']
        time.sleep(5)
        logging.info('Get Traceroute waiting for response from UMboost sid : %s, ip : %s'%(self.sessionId, self.hostIP ))
        self.TraceListObj = TraceList()
        self.TraListObj = TraList()
        status = self.TraceListObj.TraceRes(self.TraListObj , self.sessionId, self.hostIP )
        logging.debug('Length of the trace route result object : %s'%len(self.TraListObj))
        #status = 0
        logging.info('Get Traceroute status: %s'%(status))
        
        if status == -2:
            return status
        elif status == 0:
            return self.get_traceroute_results()
        else:
            return -1
    
    def get_traceroute_results(self):
        j = 0
        height = 32
        data = {}
        
        if self.req_type == 'desktop':
            html = '<ul><li class="trace_head"><div class="fl_left hopcount">Hop Count</div><div class="fl_left avgrtt">Round Trip Time</div>\
                    <div class="ip">Ipv4 Address</div></li>'
        else:
            html = '<div class="ui-grid-b heading" data-theme="b" >\
                        <div class="ui-block-a ui-bar-b center hc">Hop Count</div>\
                        <div class="ui-block-b ui-bar-b center rt">Round Trip Time</div>\
                        <div class="ui-block-b ui-bar-b center ip">Ipv4 Address</div>\
                     </div>'
            logs_html = '<div class=" ui-grid-b grid">\
                            <div class="ui-block-a hc">%s&nbsp;</div>\
                            <div class="ui-block-b rt" >%s&nbsp;</div>\
                            <div class="ui-block-c ip" >%s&nbsp;</div>\
                        </div>'

        for i in range(0,len(self.TraListObj)):
            j += 1
            height += 32
            if self.req_type == 'desktop':
                html += '<li class="clear_left">\
                           <div class="fl_left hopcount">%s</div>\
                           <div class="fl_left avgrtt">%s ms</div>\
                           <div class="ip">%s</div></li>'%( j, self.TraceListObj.get(self.TraListObj,i).avgRtt, self.TraceListObj.get(self.TraListObj,i).ip  )
            else:
                html += '<div class=" ui-grid-b grid">\
                            <div class="ui-block-a hc">%s&nbsp;</div>\
                            <div class="ui-block-b rt" >%s&nbsp;</div>\
                            <div class="ui-block-c ip" >%s&nbsp;</div>\
                            </div>'%( j, self.TraceListObj.get(self.TraListObj,i).avgRtt, self.TraceListObj.get(self.TraListObj,i).ip  )
        
        
        data['html'] = html
        data['height'] = height
        return simplejson.dumps(data)
