from kvmutils import KVMUtils, VMInfoLst, VFLst

import simplejson
import settings
logging = settings.get_logger()

class LinuxVFConf(object):
    def __init__(self, sid, ip, type):
        self.sid = sid
        self.ip = ip
        self.type = type
        self.kvmUtils = KVMUtils(self.ip, self.sid)

    def get_initial_data(self):
        
        self.unique_parent_id = '#system_content__incend__'+ self.ip.replace('.','_') +' .system_linux_vf_conf_tab'
        data_dict = {}
        vm_dict = self.getVMsData()
        
        if vm_dict == -2 or vm_dict == -1:
            return vm_dict
        
        data_dict['vm_html'] = '<ul class="ul_menu">%s</ul>'%vm_dict['vm_html']
        data_dict['mapped_vf_html'] = '<ul class="ul_menu">%s</ul>'%vm_dict['mapped_vf_html']
        data_dict['free_vf_html'] = '<ul class="ul_menu">%s</ul>'%self.getFreeVFs()
        return simplejson.dumps(data_dict)
        
    def getVMsData(self):
        
        self.agmtVMInfoLstObj = VMInfoLst()
        logging.info('Linux VF Conf: List VMs waiting for response from UMboost sid : %s , IP : %s'%(self.sid, self.ip))
        status = self.kvmUtils.listVMs(self.agmtVMInfoLstObj)
        logging.info('Linux VF Conf, List VMs status: %s'%status)
        
        if status == 0:
           return self.generateVmHtml()
        elif status == -2:
            return -2
        else:
            return -1
        
    def generateVmHtml(self):

        #Generate VM Html
        vm_html = '<li onclick="select_lin_vm(\''+ self.unique_parent_id +'\', $(this), \'%s\' )">%s\
                        <input type = "hidden" value = "%s" class = "vmid" />\
                   </li>'
        
        self.mapped_vfs_html_list = []
        self.mapped_vfs = [] 
        vm_html_list = []       
        for i in range(len(self.agmtVMInfoLstObj)):
            vmid = self.agmtVMInfoLstObj[i].id
            #Skip 0 and negative vmid's
            if vmid > 0:
                vm_html_list.append(vm_html%( vmid, self.agmtVMInfoLstObj[i].name, vmid))
                self.mapped_vfs_html_list.append( self.getMappedVFs(vmid) )
            
        returned_data = {}
        returned_data['vm_html'] = ''.join(vm_html_list)
        returned_data['mapped_vf_html'] = ''.join(self.mapped_vfs_html_list)
        return returned_data
    
    def getMappedVFs(self, vmid):
        
        self.agmtVFLstObj = VFLst()
        logging.info('Linux VF Conf: List VFs waiting for response from UMboost sid : %s , IP : %s, Vmid : %s'%(self.sid, self.ip, vmid))
        status = self.kvmUtils.listVFs(vmid, self.agmtVFLstObj)
        logging.info('Linux VF Conf - List VFs status: %s'%status)
        
        if status == 0:
           return self.generateMappedVFHtml(vmid)
        elif status == -2:
            return -2
        else:
            return -1
        
    def generateMappedVFHtml(self, vmid):
        
        current_vfs_html = '<li class="vm_%s as_hide" onclick="select_mapped_vf( \''+ self.unique_parent_id +'\', $(this) )">%s\
                            <input type="hidden" class="vfpci" value="%s" />\
                            </li>'
        current_vfs_list = []
        
        for i in range(0,len(self.agmtVFLstObj)):
            vf_str = str(self.agmtVFLstObj[i].bus)+':'+str(self.agmtVFLstObj[i].slot)+'.'+str(self.agmtVFLstObj[i].function)
            current_vfs_list.append( current_vfs_html%(vmid, vf_str, vf_str) )
            #Append already mapped vfs to mapped_vfs list, to display when its corresponding vm is selected
            self.mapped_vfs.append(vf_str)
            
        return ''.join(current_vfs_list)

    def getFreeVFs(self):
        
        self.agmtFreeVFLstObj = VFLst()
        
        logging.info('Linux VF Conf: List Free VFs waiting for response from UMboost sid : %s , IP : %s, vmid : 0'%(self.sid, self.ip))
        status = self.kvmUtils.listVFs(0, self.agmtFreeVFLstObj)
        logging.info('Linux VF Conf - List Free VFs status: %s'%status)
        
        if status == 0:
           return self.generateFreeVFHtml()
        elif status == -2:
            return -2
        else:
            return -1
        
    def generateFreeVFHtml(self):
        
        current_vfs_html = '<li onclick="select_free_vf( \''+ self.unique_parent_id +'\', $(this) )">%s\
                            <input type="hidden" class="vfpci" value="%s" />\
                            </li>'
        current_vfs_list = []
        
        for i in range(0,len(self.agmtFreeVFLstObj)):
            vf_str = str(self.agmtFreeVFLstObj[i].bus)+':'+str(self.agmtFreeVFLstObj[i].slot)+'.'+str(self.agmtFreeVFLstObj[i].function)
            #Append only un mapped vfs to the list
            if vf_str not in self.mapped_vfs:
                current_vfs_list.append( current_vfs_html%(vf_str, vf_str) )
        
        return ''.join(current_vfs_list)
        
   
    def add_vf_to_vm(self, data):
        
        vfpci_str = data['vfpci'][1:len(data['vfpci'])-1].replace(',,',',')
        vfpci_list = vfpci_str.split(',')
        
        if len(vfpci_list) == 1:
            logging.info('Linux VF Conf: Assign Vf to VM waiting for response from UMboost sid : %s , IP : %s, vmuuid : %s, vfpci : %s\
                        '%(self.sid, self.ip, data['vmid'], vfpci_list[0]))
            status = self.kvmUtils.addVFToVM(int(data['vmid']), vfpci_list[0])
            logging.info('Linux VF Conf: Assign Vf to VM status: %s'%status)
        else:
            for i in vfpci_list:
                logging.info('Linux VF Conf: Assign Vf to VM waiting for response from UMboost sid : %s , IP : %s, vmuuid : %s, vfpci : %s\
                    '%(self.sid, self.ip, data['vmid'], i))
                status = self.kvmUtils.addVFToVM(int(data['vmid']), i)
                logging.info('Linux VF Conf: Assign Vf to VM status: %s'%status)
        
        if status == 0 or status == -2:
           return status
        else:
            return -1
        
    def remove_vf_to_vm(self, data):
        
        vfpci_str = data['vfpci'][1:len(data['vfpci'])-1].replace(',,',',')
        vfpci_list = vfpci_str.split(',')
        
        if len(vfpci_list) == 1:
            logging.info('Linux VF Conf: Remove Vf from VM waiting for response from UMboost sid : %s , IP : %s, vmuuid : %s, vfpci : %s\
                        '%(self.sid, self.ip, data['vmid'], vfpci_list[0]))
            status = self.kvmUtils.detachVFFrmVM(int(data['vmid']), vfpci_list[0])
            logging.info('Linux VF Conf: Remove Vf from VM status: %s'%status)
        else:
            for i in vfpci_list:
                logging.info('Linux VF Conf: Remove Vf from VM waiting for response from UMboost sid : %s , IP : %s, vmuuid : %s, vfpci : %s\
                    '%(self.sid, self.ip, data['vmid'], i))
                status = self.kvmUtils.detachVFFrmVM(int(data['vmid']), i)
                logging.info('Linux VF Conf: Remove Vf from VM status: %s'%status)
        
        if status == 0 or status == -2:
           return status
        else:
            return -1