from kvmutils import KVMUtils, VMInfoLst

import time
import settings
logging = settings.get_logger()

class LinuxKvmConf(object):
    def __init__(self, sid, ip):
        self.sid = sid
        self.ip = ip
        self.kvmUtils = KVMUtils( ip, sid)  

    def get_linux_conf_data(self):
        
        self.agmtVMInfoLstObj = VMInfoLst()
        logging.info('Linux KVM Configuration ListVMs waiting for response from UMboost sid : %s , IP : %s'%(self.sid, self.ip))
        status = self.kvmUtils.listVMs( self.agmtVMInfoLstObj )
        logging.info('Linux KVM Configuration ListVMs status: %s'%status)
        
        if status == 0:
            return self.generateHtml()
        elif status == -2:
            return -2
        else:
            return -1
        
    def generateHtml(self):
        
        unique_parent_id = '#system_content__incend__'+ self.ip.replace('.','_') +' .system_linux_kvm_conf_tab';
        html = '<li class="vms" onclick="display_lin_conf_data(\''+ unique_parent_id +'\', $(this))">%s\
                <input type = "hidden" value = "%s" class = "uuid" />\
                <input type = "hidden" value = "%s" class = "domain_state" />\
                </li>'
                
        html_list = [ html%( self.agmtVMInfoLstObj[i].name,\
                             self.agmtVMInfoLstObj[i].uuid,\
                             self.agmtVMInfoLstObj[i].domainState)\
                     for i in range(len(self.agmtVMInfoLstObj)) ]
        
        return '<ul class="vm_ul">'+''.join(html_list)+'</ul>'
    
    
    def perform_operation(self, data):
        
        Obj = self.kvmUtils
        #Slicing the string removing the first and last comma.
        vm_uuid = data['vm_uid'][1:len(data['vm_uid'])-1]
        vm_uuid_list = vm_uuid.split(',,')
        
        if len(vm_uuid_list) > 1:
            for i in vm_uuid_list:
                logging.info('Mult Perform Linux KVM Configuration operation waiting for response from UMboost sid : %s , IP : %s, \
                              vm_uuid : %s, operation : %s'%(self.sid, self.ip, i, data['operation']))
                status = Obj.performStateOperation(i, int(data['operation']))
                #status = 0
                logging.info('Perform Linux KVM Configuration operation status: %s'%status)
        else:
             logging.info('Single Perform Linux KVM Configuration operation waiting for response from UMboost sid : %s , IP : %s, \
                          vm_uuid : %s, operation : %s'%(self.sid, self.ip, vm_uuid, data['operation']))
             status = Obj.performStateOperation(vm_uuid, int(data['operation']))
             #status = 0
             logging.info('Perform Linux KVM Configuration operation status: %s'%status)
             
        if status == 0:
            time.sleep(10)
            return status
        elif status == 0:
            return status
        else:
            return -1
    
    