from kvmutils import BridgeLst, VMInfoLst, KVMUtils, IfNameLst

import settings, utils, simplejson
logging = settings.get_logger()

class LinAddVirtualNwConf(object):
    
    def __init__(self, sid, ip, type):
        self.sid = sid
        self.ip = ip
        self.type = type
        self.kvmUtils = KVMUtils( ip, sid)
    
    def get_initial_data(self):
        
        data = {}
        bridge_dict = self.list_bridge()
        
        if type(bridge_dict) == dict:
            data.update(self.list_bridge()) 
        data['vm_html'] = self.list_vms()
        data['interface_html'] = self.list_interface()
        return simplejson.dumps(data)
        
    def list_bridge(self):
        
        logging.info('Hypervisor - Linux Virtual Network Configuration listBridges: Sid : %s, Ip : %s'%( self.sid, self.ip ))
        self.agmtBridgeLstObj = BridgeLst()  
        status = self.kvmUtils.listBridges(self.agmtBridgeLstObj)
        logging.info('Hypervisor - Linux Virtual Network Configuration listBridges status : %s, len : %s'%( status, len(self.agmtBridgeLstObj)))
        
        if status == 0:
            return  self.build_bridge_html()
        elif status == -2:
            return -2
        else:
            return -1
        
    def build_bridge_html(self):
        
        bridge_html = '<option value="%s">%s</option>'
        
        second_wr_bridge_html_list = []
        third_wr_bridge_html_list = []
        for i in range(len(self.agmtBridgeLstObj)):
            
            bridge_name = self.agmtBridgeLstObj[i].name
            third_wr_bridge_html_list.append(bridge_html %( bridge_name, bridge_name ) )
            
            logging.info('Hypervisor - Linux Virtual Network Configuration listBridgeInterfaces: Sid : %s, Ip : %s, bridge_name : %s'%( self.sid, self.ip, bridge_name ))
            agmtBridgeInterfacesObj = IfNameLst()
            status = self.kvmUtils.listBridgeInterfaces(bridge_name, agmtBridgeInterfacesObj)
            logging.info('Hypervisor - Linux Virtual Network Configuration listBridgeInterfaces status : %s'%( status ))
            
            #One the Add Bridge to VM, dont display bridges which doesnt have any interfaces
            if status != 0 or len(agmtBridgeInterfacesObj) == 0:
                continue
            
            second_wr_bridge_html_list.append(bridge_html %( bridge_name, bridge_name ) )
            
        
        data = {}
        data['second_wr_bridge_html'] = '<select class="bridge">%s</select>'%(''.join(second_wr_bridge_html_list))
        data['third_wr_bridge_html'] = '<select class="bridge">%s</select>'%(''.join(third_wr_bridge_html_list))
        return data
        
    def list_vms(self):
        
        logging.info('Hypervisor - Linux Virtual Network Configuration List Vms sid : %s , IP : %s'%(self.sid, self.ip))
        self.agmtVMInfoLstObj = VMInfoLst()
        status = self.kvmUtils.listVMs( self.agmtVMInfoLstObj )
        logging.info('Hypervisor - Linux Virtual Network Configuration List Vms status: %s'%status)
        
        if status == 0:
            return  self.build_vm_html()
        elif status == -2:
            return -2
        else:
            return -1
        
    def build_vm_html(self):
        
        vm_html = '<option value="%s">%s</option>'
        vm_html_list = []
        for i in range(len(self.agmtVMInfoLstObj)):
            vmid = self.agmtVMInfoLstObj[i].id
            
            #Skip vm with id < 0
            if vmid < 0:
                continue
            
            vm_html_list.append(vm_html %( vmid, self.agmtVMInfoLstObj[i].name  ))
        
        return '<select class="vm">%s</select>'%(''.join(vm_html_list))
    
    
    def list_interface(self):
        
        logging.info('Hypervisor - Linux Virtual Network Configuration list Interfaces: Sid : %s, Ip : %s'%( self.sid, self.ip ))
        self.agmtBridgeInterfacesObj = IfNameLst()
        status = self.kvmUtils.listBridgebleInterfaces(self.agmtBridgeInterfacesObj)
        #status = 0
        logging.info('Hypervisor - Linux Virtual Network Configuration list Interfaces status : %s'%( status ))
        
        if status == 0:
            return  self.build_interface_html()
        elif status == -2:
            return -2
        else:
            return -1
        
    def build_interface_html(self):
        
        if_html = '<option value="%s">%s</option>'
        if_html_list = []
        for i in range(len(self.agmtBridgeInterfacesObj)):
            ifname = self.agmtBridgeInterfacesObj[i]
            if_html_list.append(if_html %( ifname, ifname ))
        
        return '<select class="interface">%s</select>'%(''.join(if_html_list))
    
    
    def create_bridge(self, data):
        
        logging.info('Hypervisor - Linux Virtual Network Configuration Create Bridge: Sid : %s, Ip : %s, brname : %s'%( self.sid, self.ip, data['bname'] ))
        status = self.kvmUtils.createBridge(data['bname'])
        logging.info('Hypervisor - Lin virtual Network Configuration create bridge status : %s'%( status ))
        
        if status == -2:
            return status
        elif status == 0:
            return self.set_bridge_props(data)
        else:
            return -1
        
    def set_bridge_props(self, data):
        
        #Generate Input xml string
        bridge_props = '<Bridge Name = "%s" \
                            AgingTime = "%s" \
                             ForwardDelay = "%s" \
                             HelloTime = "%s" \
                             MaxAge = "%s" \
                             Priority = "%s" \
                             STP = "%s"> \
                        </Bridge>'%( data['bname'], data['agingtime'], data['forward_delay'], data['hello_time'], data['max_age'], data['priority'], data['stp']  )
        
        logging.info('Hypervisor - Linux Virtual Network Configuration Set Bridge Props: Sid : %s, Ip : %s, XMl : %s'%( self.sid, self.ip, bridge_props ))
        status = self.kvmUtils.setBridgeProperty( bridge_props )
        logging.info('Hypervisor - Lin virtual Network Configuration Set Bridge Props status : %s'%( status ))
        
        if status == -2 or status == 0:
            return status
        else:
            return -1
        
    def add_bridge_to_vm(self, data):
        
        logging.info('Hypervisor - Linux Virtual Network Configuration Add Bridge to VM: Sid : %s, Ip : %s, brname : %s, vmid : %s'%( self.sid, self.ip, data['brname'], data['vmid'] ))
        status = self.kvmUtils.addBridgeToVM( data['brname'], int(data['vmid']) )
        logging.info('Hypervisor - Lin virtual Network Configuration Add Bridge to VM status : %s'%( status ))
        
        if status == 0 or status == -2:
            return status
        else:
            return -1
        
    def add_interface_to_bridge(self, data):
        
        logging.info('Hypervisor - Linux Virtual Network Configuration Add Interface to Bridge: Sid : %s, Ip : %s, brname : %s, ifname : %s'%( self.sid, self.ip, data['brname'], data['interface'] ))
        status = self.kvmUtils.addInterfaceToBridge(data['brname'], data['interface'])
        logging.info('Hypervisor - Lin virtual Network Configuration Add Interface to Bridge status : %s'%( status ))
        
        if status == -2:
            return status
        elif status == 0:
            return self.set_interface_props(data)
        else:
            return -1
        
    def set_interface_props(self, data):   
    
        interface_xml = '<Bridge Name = "%s" AgingTime = "" ForwardDelay = "" HelloTime = "" MaxAge = "" Priority = "" STP = ""> \
                            <Port Name = "%s" Cost = "%s" Priority = "%s"/>\
                        </Bridge>'%( data['brname'], data['interface'], data['cost'], data['priority'] )
        
        logging.info('Hypervisor - Linux Virtual Network Configuration Set Interface Props: Sid : %s, Ip : %s, xml : %s '%( self.sid, self.ip, interface_xml ))
        status = self.kvmUtils.setBridgeProperty( interface_xml )
        logging.info('Hypervisor - Lin virtual Network Configuration Set Interface Props status : %s'%( status ))
        
        if status == 0 or status == -2:
            return status
        else:
            return -1