from UmBoostLib import targetList, tarList, TLunList, LunList, TarLunInfo
import simplejson, UmBoostLib

import logging
import settings
logging.basicConfig(filename=settings.log_path,level=logging.DEBUG)


class IscsiTargetLunUpdate:
    
    def __init__(self, sid, ip):
         self.sid = sid
         self.ip = ip

    def get_targets(self, data):
        self.req_type = data['req_type']
        logging.info('iSCSI Target LUN Update Get Targets List: Sid : %s, Ip : %s'%( self.sid, self.ip ))
        self.boosttarlistobj = tarList()
        self.boosttargetlistobj = targetList()
        status = self.boosttargetlistobj.getiSCSITargetInformation( self.boosttarlistobj, self.sid, self.ip )
        logging.info('iSCSI Target LUN Update Get Targets List status: %s'%status)

        if status == 0:
            return self.generate_tagetlist_html()
        elif status == -2 or status == 67:
            return status
        else:
            return -1
        
    def generate_tagetlist_html(self):
        
        ip_id = self.ip.replace('.','_')
        if self.req_type == 'desktop':
            unique_parent_id = '#lun_content__incend__%s .lun_content_update_lun_tab'%ip_id
        else:
            unique_parent_id = '#lun_update__%s__incend'%ip_id
        
        loader_selector = '%s .initializer'%unique_parent_id
        select_head_html = '<select onchange="i_lu_get_luns(\'%s\', \'%s\', \'%s\', \'%s\')" class="targets_list" >\
                            <option value="null">Select One..</option>\
                            '%(unique_parent_id, ip_id, self.ip, loader_selector)
        select_html = '%s%s</select>'
        option_html = '<option value="%s" title = "%s" >%s</option>'
        html_list = [  option_html%( i+1, self.boosttargetlistobj.get(self.boosttarlistobj,i).CurrentState, self.boosttargetlistobj.get(self.boosttarlistobj,i).TargetName ) for i in range(0,len(self.boosttarlistobj)) ] 
        html = ''.join(html_list)
        select_html = select_html%(select_head_html, html)
        return select_html    
    
    def get_lun_list(self, index, ostype):
    
        logging.info('iSCSI Target LUN Update Get LUN List: Sid : %s, Ip : %s, Index : %s, ostype : %s'%( self.sid, self.ip, index, ostype))
        self.boost_lun_listobj = LunList()
        self.boost_t_lun_listobj = TLunList()
        status = self.boost_t_lun_listobj.getiSCSITargetLuns( self.boost_lun_listobj, self.sid, self.ip, int(index), int(ostype) )
        logging.info('iSCSI Target LUN Update Get LUN List status: %s'%status)

        if status == 0:
            return self.generate_lunlist_html()
        elif status == -2:
            return -2
        else:
            return -1
    
    def generate_lunlist_html(self):
        
        ip_id = self.ip.replace('.','_')
        unique_parent_id = '#lun_content__incend__%s .lun_content_update_lun_tab'%ip_id
        loader_selector = '%s .initializer'%unique_parent_id
        lun_event_fn = 'i_lu_lun_select($(this), \'%s\', \'%s\', \'%s\', \'%s\')'%(unique_parent_id, ip_id, self.ip, loader_selector)
        
        lun_ul_html = '<ul class="ul_menu select_ul">%s</ul>'
        lun_li_html = '<li class="lun hover_li position_%s" onclick="%s" name="position_%s" >%s%s%s%s%s%s%s</li>'
        lun_name_html = '<input type="hidden" class = "lunname" value="%s" />'        
        lun_ramdisk_html = '<input type="hidden" class = "ramdisk" value="%s" />'
        lun_permissions_html = '<input type="hidden" class = "permissions" value="%s" />'
        lun_devicetype_html = '<input type="hidden" class = "devicetype" value="%s" />'
        lun_options_html = '<input type="hidden" class = "options" value="%s" />'
        lun_name_str_html = '<input type="hidden" class = "lunnamestr" value="%s" />'
        html_list = [ lun_li_html%( i+1, lun_event_fn, i+1, self.boost_t_lun_listobj.get(self.boost_lun_listobj,i).LunName,
                                    lun_name_html %  self.boost_t_lun_listobj.get(self.boost_lun_listobj,i).LunName,
                                    lun_ramdisk_html %  self.boost_t_lun_listobj.get(self.boost_lun_listobj,i).RamdiskSizeMB,
                                    lun_permissions_html %  self.boost_t_lun_listobj.get(self.boost_lun_listobj,i).ReadOnly, 
                                    lun_devicetype_html % self.boost_t_lun_listobj.get(self.boost_lun_listobj,i).Mode,
                                    lun_options_html % self.boost_t_lun_listobj.get(self.boost_lun_listobj,i).Options,
                                    lun_name_str_html % self.boost_t_lun_listobj.get(self.boost_lun_listobj,i).LunNameStr,
                                   ) for i in range(0,len(self.boost_lun_listobj)) ]
        html = ''.join(html_list)
        lun_ul_html = lun_ul_html%(html)
        return lun_ul_html
    
    def set_lunlist_order(self, index, lunnamestr):
        logging.info('iSCSI Target LUN Update Set Lun List Order: Sid : %s, Ip : %s, index : %s, lunnamestr : %s'%( self.sid, self.ip, index, lunnamestr ))
        self.boost_tarlun_obj = TarLunInfo()
        status = self.boost_tarlun_obj.ReorderLuns( self.sid, self.ip, int(index), lunnamestr )
        #status = 0
        logging.info('iSCSI Target LUN Update Set Lun List Order: %s'%status)

        if status == 0:
            return 0
        elif status == -2:
            return -2
        else:
            return -1
    
    def delete_lun(self, index, lunnamestr):
        logging.info('iSCSI Target LUN Update Delete Lun : Sid : %s, Ip : %s, index : %s, lunnamestr : %s'%( self.sid, self.ip, index, lunnamestr.strip() ))
        self.boost_tarlun_obj = TarLunInfo()
        status = self.boost_tarlun_obj.DeleteLun( self.sid, self.ip, int(index), lunnamestr.strip() )
        #status = 0
        logging.info('iSCSI Target LUN Update Delete Lun: %s'%status)

        if status == 0:
            return 0
        elif status == -2:
            return -2
        else:
            return -1
    
    