from UmBoostLib import targetList, tarList, SDList, TSDList, TarLunInfo, LunList, TLunList

import logging
import settings
logging.basicConfig(filename=settings.log_path,level=logging.DEBUG)


class IscsiTargetAddLun:
    
    def __init__(self, sid, ip):
         self.sid = sid
         self.ip = ip

    def get_targets_list(self, data):
        logging.info('iSCSI Target Add LUN Get Targets List: Sid : %s, Ip : %s'%( self.sid, self.ip ))
        self.boosttarlistobj = tarList()
        self.boosttargetlistobj = targetList()
        status = self.boosttargetlistobj.getiSCSITargetInformation( self.boosttarlistobj, self.sid, self.ip )
        logging.info('iSCSI Target LUN Update Get Targets List status: %s'%status)
        
        if status == 0:
            return self.generate_tagetlist_html()
        elif status == -2 or status == 67:
            return status
        else:
            return '-1'
    
    def generate_tagetlist_html(self):
        ip_id = self.ip.replace('.','_')
        unique_parent_id = '#lun_content__incend__%s .lun_content_add_lun_tab'%ip_id
        select_head_html = '<select class="targets_list" onchange="i_add_lun_get_next_ramdisk($(this), \'%s\', \'%s\')" >\
                            <option value="null">Select One..</option>%s\
                            </select>'
        option_html = '<option value="%s" >%s</option>'
        html_list = [  option_html%( i+1, self.boosttargetlistobj.get(self.boosttarlistobj,i).TargetName ) for i in range(0,len(self.boosttarlistobj)) ] 
        html = ''.join(html_list)
        select_html = select_head_html%(unique_parent_id, self.ip, html)
        return select_html 
    
    def get_devices(self, ostype):
        logging.info('iSCSI Target Add LUN Get Devices List: Sid : %s, Ip : %s, ostype : %s'%( self.sid, self.ip, ostype ))
        self.boost_tsdlist_obj = TSDList()
        self.boost_sdlist_obj = SDList()
        status = self.boost_tsdlist_obj.getiSCSITargetDevices( self.boost_sdlist_obj, self.sid, self.ip, int(ostype) )
        logging.info('iSCSI Target Add LUN Get Devices List status: %s'%status)
        
        if status == 0:
            return self.generate_devices_html()
        elif status == -2 or status == 67:
            return status
        else:
            return '-1'
    
    def generate_devices_html(self):
        ip_id = self.ip.replace('.','_')
        unique_parent_id = '#lun_content__incend__%s .lun_content_add_lun_tab'%ip_id
        loader_selector = '%s .initializer'%unique_parent_id
        change_fn = 'i_la_show_type($(this), \'%s\', \'%s\', \'%s\', \'%s\')'%(unique_parent_id, ip_id, self.ip, loader_selector)
        select_head_html = '<select onchange="'+ change_fn +'" class="devices_list" >\
                            <option value="null">Select One..</option>%s\
                            <option value="5" name="5" >Ram Disk</option>\
                            </select>'
        option_html = '<option value="%s" name = "%s" >%s - %s</option>'
        html_list = [  option_html%( i+1, self.boost_tsdlist_obj.get(self.boost_sdlist_obj,i).Type, self.boost_tsdlist_obj.get(self.boost_sdlist_obj,i).Path, self.boost_tsdlist_obj.get(self.boost_sdlist_obj,i).Size ) for i in range(0,len(self.boost_sdlist_obj)) ] 
        html = ''.join(html_list)
        select_html = select_head_html%(html)
        return select_html            
    
    def add_lun(self, index, string):
        logging.info('iSCSI Target Add New LUN : Sid : %s, Ip : %s, Index : %s, string : %s'%( self.sid, self.ip, index, string ))
        boost_tarluninfo_obj = TarLunInfo()
        status = boost_tarluninfo_obj.AddLun( self.sid, self.ip, int(index), string )
        logging.info('iSCSI Target Add New LUN status: %s'%status)

        if status == 0:
            return 0
        elif status == -2:
            return -2
        else:
            return -1
        
    def get_next_ramdisk(self, index, ostype):
    
        logging.info('iSCSI Target Add LUN : Get next ramdisk: Sid : %s, Ip : %s, Index : %s, ostype : %s'%( self.sid, self.ip, index, ostype))
        self.boost_lun_listobj = LunList()
        self.boost_t_lun_listobj = TLunList()
        status = self.boost_t_lun_listobj.getiSCSITargetLuns( self.boost_lun_listobj, self.sid, self.ip, int(index), int(ostype) )
        logging.info('iSCSI Target Add LUN Get next ramdisk status: %s'%status)

        if status == 0:
            next_ramdisk_no = 0
            for i in range(0,len(self.boost_lun_listobj)):
                lunname = self.boost_t_lun_listobj.get(self.boost_lun_listobj,i).LunName
                if lunname.find('ramdisk') != -1:
                    next_ramdisk_no = lunname.split('ramdisk')[1]
            try:
                next_ramdisk_no = int(next_ramdisk_no)+1
            except:
                next_ramdisk_no = 0
            return next_ramdisk_no
        elif status == -2:
            return -2
        else:
            return -1