from UmBoostLib import targetList, tarList, ACLInfo 

import logging
import settings
logging.basicConfig(filename=settings.log_path,level=logging.DEBUG)

class IscsiTargetAddAcl:
    
    def __init__(self, sid, ip):
        self.sid = sid
        self.ip = ip

    def get_targets(self,):
        logging.info('iSCSI Target Add Acl: Sid : %s, Ip : %s'%( self.sid, self.ip ))
        self.boosttarlistobj = tarList()
        self.boosttargetlistobj = targetList()
        status = self.boosttargetlistobj.getiSCSITargetInformation( self.boosttarlistobj, self.sid, self.ip )
        logging.info('iSCSI Target Add Acl: %s'%status)

        if status == 0:
            return self.generate_tagetlist_html()
        elif status == -2 or status == 67:
            return status
        else:
            return -1
        
    def generate_tagetlist_html(self):
        
        select_html = '<select class="targets_list" onchange="$(this).removeClass(\'error\')" >\
                            <option value="null">Select One..</option>%s\
                            </select>'
        option_html = '<option value="%s" >%s</option>'
        html_list = [ option_html%( i+1, self.boosttargetlistobj.get(self.boosttarlistobj,i).TargetName ) for i in range(0,len(self.boosttarlistobj)) ] 
        html = ''.join(html_list)
        select_html = select_html%( html )
        return select_html   
    
    def save_acl(self, index, acl_string):
        logging.info('iSCSI Target Add Acl : Sid : %s, Ip : %s, Index : %s, ACLstring : %s'%( self.sid, self.ip, index, acl_string ))
        boost_aclinfo_obj = ACLInfo()
        status = boost_aclinfo_obj.AddACL( self.sid, self.ip, int(index), acl_string )
        #status = 0
        logging.info('iSCSI Target Add New Acl status: %s'%status)

        if status == 0:
            return 0
        elif status == -2:
            return -2
        else:
            return -1
    