from UmBoostLib import TDiscList, tarDiscList, TPGList, PGList, TarInformation, iSessList, SessList, iConnList, connList, lDiskList, diskList, iniIPList, ipList
from UmBoostLib import iniList, initiatorList, ConnectionInfo
from IscsiInitiatorDiscoverTargetsFile import IscsiInitiatorDiscoverTargets

import settings, simplejson
logging = settings.get_logger()

class IscsiInitiatorTargets:
    
    def __init__(self, sid, ip, req_type):
         self.sid = sid
         self.ip = ip
         self.req_type = req_type
         #By default its 1
         self.portal_index = 1
    
    def get_targets(self, stack, ostype):
       self.ostype = ostype 
       #Windows - looping through each nodes of stack 24 - chelsio iscsi
       iscs_dt_obj = IscsiInitiatorDiscoverTargets( self.sid, self.ip, self.req_type ) 
       if stack == '24' or stack == '27':
           #Expected values are -1 Failed, -2 Session timeout or Length of the node
           nodes_status = iscs_dt_obj.get_nodes(stack, True)
           logging.info('-----------------Win specific Returned Node Value : %s'%nodes_status)
           if nodes_status == -2 or nodes_status == -1:
               return nodes_status
           elif nodes_status == -6:
               return 1
           else:
               targets_html = ''
               portals_html = ''
               for i in range(1,nodes_status+1):
                   self.boostTDiscListobj = TDiscList()
                   self.boosttDiscListobj = tarDiscList()
                   status = self.boostTDiscListobj.getTargets( self.boosttDiscListobj, self.sid, self.ip, int(stack), i, int(self.ostype) )
                   logging.info('-----------------Win getTargets Status : %s , for node index : %s'%(status, i ))
                   if status == 0: 
                       self.portal_index = i
                       targets_html += self.generate_targets_html(stack)
                   elif status == -2:
                       return -2
                   else:
                       continue
               return targets_html
       else: 
           self.boostTDiscListobj = TDiscList()
           self.boosttDiscListobj = tarDiscList()
           
           logging.info('iSCSI Initiator Targets 3rd panel - Get Targets : waiting for response from UMboost sid : %s , UmServerIP : %s , Stack : %s, ostype : %s\
                       '%( self.sid, self.ip, stack, self.ostype ))
           status = self.boostTDiscListobj.getTargets( self.boosttDiscListobj, self.sid, self.ip, int(stack), 1, int(self.ostype) )
           logging.info('iSCSI Initiator Targets - Get Targets Status : %s'%( status ))
           
           if status == 0: 
               return self.generate_targets_html(stack)
           elif status == 179:
               return 1
           elif status == -2 or status == 1 or status == 67:
               return status
           else:
               return -1
       
    def generate_targets_html(self, stack):
        ip_id = self.ip.replace('.','_')
        if self.req_type == 'desktop':
            unique_parent_id = '#iscsi_initiator_content__incend__%s .iscsi_initiator_targets_tab'%(ip_id)
        else:
            unique_parent_id = '#i_in_t__%s__incend'%ip_id
        
        targets_html = ['<li class="targets" onclick = "i_in_t_target_select(\'%s\', $(this), %s, %s, %s, \'%s\')"> %s\
                         <input type = "hidden" class = "stack" value = "%s" />\
                         <input type = "hidden" class = "targetname" value = "%s" />\
                         <input type = "hidden" class = "index"  value = "%s" />\
                         %s</li>\
                        '%( unique_parent_id,
                            self.boostTDiscListobj.get(self.boosttDiscListobj,i).IsPersistent,
                            self.boostTDiscListobj.get(self.boosttDiscListobj,i).IsLoggedIn,
                            stack,
                            self.ip,
                            self.boostTDiscListobj.get(self.boosttDiscListobj,i).TargetName,
                            stack,
                            self.boostTDiscListobj.get(self.boosttDiscListobj,i).TargetName,
                            self.portal_index,
                            self.get_portal(stack, self.boostTDiscListobj.get(self.boosttDiscListobj,i).TargetName)
                            )
                            for i in range(0, len(self.boosttDiscListobj))]
        return ''.join(targets_html)
    
    def get_portal(self, stack, target_name):
        
       if stack == '24' or stack == '27':
           node_idx = self.portal_index
       else:
           node_idx = 1
       
       boostTPGListobj = TPGList()
       boostPGListobj = PGList()
       logging.info('iSCSI Initiator Targets - Get Portals : waiting for response from UMboost sid : %s , UmServerIP : %s ,\
                     Stack : %s, nodeIdx : %s, tarName : %s, discFlag : 1, ostype : %s\
                     '%( self.sid, self.ip, stack, node_idx, target_name, self.ostype ))
       status = boostTPGListobj.getiSCSIDiscoveredTargetPGs( boostPGListobj, self.sid, self.ip, int(stack), int(node_idx), target_name, 1, int(self.ostype) )
       logging.info('iSCSI Initiator Targets - Get Portals Status : %s'%( status ))
       
       portal = '<input type="hidden" value="%s:%s" class="portal" />'
       portal_list = [ portal%(
                      boostTPGListobj.get(boostPGListobj,i).IPAddress,
                      boostTPGListobj.get(boostPGListobj,i).Port)
                      for i in range(0, len(boostPGListobj)) ] 
        
       return ''.join(portal_list)
       
    def delete_targets(self, data):
        
       boostDelobj = TarInformation()
       logging.info('iSCSI Initiator Targets 3rd panel - Delete Targets : waiting for response from UMboost sid : %s , UmServerIP : %s , Stack : %s, nodeIdx : %s\
                        Target Name : %s, Portal : %s, iniIP : %s, PerFlag : %s\
                   '%( self.sid, self.ip, data['stack'], data['index'], data['tarname'], data['portal'], data['iniIP'], data['perflag'] ))
       status = boostDelobj.DeliSCSITarget( self.sid, self.ip, int(data['stack']), int(data['index']), data['tarname'], data['portal'], data['iniIP'], int(data['perflag']) )
       logging.info('iSCSI Initiator Targets 3rd panel - Delete Targets Status : %s'%( status ))
       
       if status == 0 or status == -2: 
           return status
       else:
           return -1
       
    def logout(self, data):
        
       boostLogoutobj = TarInformation()
       if int(data['sessid_count']) > 1:
           for i in range(int(data['sessid_count'])):
               logging.info('iSCSI Initiator Targets 3rd panel - Logout Targets : waiting for response from UMboost sid : %s , UmServerIP : %s , Stack : %s, nodeIdx : %s, Sessid : %s\
                   '%( self.sid, self.ip, int(data['stack']), data['index'], data['sessid'][i] ))
               status = boostLogoutobj.TargetLogout( self.sid, self.ip, int(data['stack']), int(data['index']), data['sessid'][i] )
               logging.info('iSCSI Initiator Targets 3rd panel - Logout Targets Status : %s'%( status ))
       else:
           logging.info('iSCSI Initiator Targets 3rd panel - Logout Targets : waiting for response from UMboost sid : %s , UmServerIP : %s , Stack : %s, nodeIdx : %s, Sessid : %s\
               '%( self.sid, self.ip, int(data['stack']), data['index'], data['sessid'] ))
           status = boostLogoutobj.TargetLogout( self.sid, self.ip, int(data['stack']), int(data['index']), data['sessid'] )
           logging.info('iSCSI Initiator Targets 3rd panel - Logout Targets Status : %s'%( status ))
       
       if status == 0 or status == -2: 
           return status
       else:
           return -1  
    
    def session_logout(self, stack, sessid, index):
        
       boostLogoutobj = TarInformation()
       logging.info('iSCSI Initiator Targets 3rd panel - Session Logout : waiting for response from UMboost sid : %s , UmServerIP : %s , Stack : %s, nodeIdx : %s, Sessid : %s\
           '%( self.sid, self.ip, stack, index, sessid ))
       status = boostLogoutobj.TargetLogout( self.sid, self.ip, int(stack), int(index), sessid )
       logging.info('iSCSI Initiator Targets 3rd panel - Session Logout Status : %s'%( status ))
       
       if status == 0 or status == -2: 
           return status
       else:
           return -1
       
    def get_session(self, stack, ostype):
        
       self.boostISListobj = iSessList()
       self.boostSListobj = SessList()
       
       logging.info('iSCSI Initiator Targets 3rd panel - Get Session ids : waiting for response from UMboost sid : %s , UmServerIP : %s , Stack : %s, ostype : %s\
                   '%( self.sid, self.ip, stack, ostype ))
       status = self.boostISListobj.getSessionList( self.boostSListobj, self.sid, self.ip, int(stack), int(ostype) )
       logging.info('iSCSI Initiator Targets - Get Session status: %s'%( status ))
       
       if status == 0: 
           return self.generate_session_html(stack)
       elif status == -2:
           return status
       else:
           return -1
       
    def generate_session_html(self, stack):
        ip_id = self.ip.replace('.','_')
        unique_parent_id = '#iscsi_initiator_content__incend__%s .iscsi_initiator_targets_tab'%(ip_id)
        
        sessions_html = ['<li class="sessions %s as_hide" onclick = "i_in_t_get_connections(\'%s\', $(this), %s, \'%s\', \'%s\', \'%s\', \'%s\');\
                            i_in_t_get_disks(\'%s\', $(this), %s, \'%s\' , \'%s\' )">%s\
                            <input type="hidden" value="%s" class="sessid" />\
                            </li>\
                        '%( self.boostISListobj.get(self.boostSListobj,i).TargetName.replace(' ','').replace('.','_'), 
                            unique_parent_id,
                            stack,
                            self.boostISListobj.get(self.boostSListobj,i).SessionID,
                            self.boostISListobj.get(self.boostSListobj,i).InitiatorName,
                            self.boostISListobj.get(self.boostSListobj,i).TargetName,
                            self.ip,
                            unique_parent_id,
                            stack,
                            self.boostISListobj.get(self.boostSListobj,i).SessionID,
                            self.ip,
                            self.boostISListobj.get(self.boostSListobj,i).SessionID,
                            self.boostISListobj.get(self.boostSListobj,i).SessionID
                            )
                            for i in range(0, len(self.boostSListobj))]
        return ''.join(sessions_html)
    
    def get_connections(self, data):
       self.boostICListobj = iConnList()
       self.boostCListobj = connList()
       
       self.ostype = data['ostype']
       self.stack = data['stack']
       self.sessid = data['sessid']
       logging.info('iSCSI Initiator Targets 3rd panel - Get connections : waiting for response from UMboost sid : %s , UmServerIP : %s , Stack : %s, SessionId : %s, ostype : %s\
                    iniName : %s, tarName : %s\
                   '%( self.sid, self.ip, data['stack'], data['sessid'], data['iniName'], data['tarName'], data['ostype'] ))
       status = self.boostICListobj.getConnectionList( self.boostCListobj, self.sid, self.ip, int(data['stack']), data['sessid'], data['iniName'], data['tarName'], int(data['ostype'])  )
       logging.info('iSCSI Initiator Targets 3rd panel - Get connections status: %s'%( status ))
       
       if status == 0: 
           return self.generate_connection_html()
       elif status == -2:
           return status
       else:
           return -1
       
    def generate_connection_html(self):
        
        fn = ''
        if self.ostype == '1':
            unique_parent_id = '#iscsi_initiator_content__incend__%s .iscsi_initiator_targets_tab'%( self.ip.replace('.', '_') )
            fn = "onclick='i_target_conn_select(\"%s\", $(this))'"%( unique_parent_id )
        
        connections_html = ['<li class="connections" %s >Initiator: %s:%s -> Target: %s:%s ; CID: %s\
                                <input type="hidden" value="%s" class="cid" />\
                            </li>'%(
                            fn, 
                            self.boostICListobj.get(self.boostCListobj,i).InitiatorAddress,
                            self.boostICListobj.get(self.boostCListobj,i).InitiatorPort,
                            self.boostICListobj.get(self.boostCListobj,i).TargetAddress,
                            self.boostICListobj.get(self.boostCListobj,i).Targetport,
                            self.boostICListobj.get(self.boostCListobj,i).CID,
                            self.boostICListobj.get(self.boostCListobj,i).CID )
                            for i in range(0, len(self.boostCListobj))]
        return ''.join(connections_html)
    
    def login(self, data):
        
       boostLoginObj = TarInformation()
       logging.info('iSCSI Initiator Targets 3rd panel - Target Login : waiting for response from UMboost sid : %s , UmServerIP : %s , Stack : %s, nodeIdx : %s\
                        Target Name : %s, Portal : %s, iniIP : %s, persists : %s, mpio : %s, auth : %s, IniChapUser : %s, IniChapPass : %s\
                        , TargetChapUser : %s, TargetChapPass : %s, hdigest : %s, ddigest : %s\
                   '%( self.sid, self.ip, data['stack'], data['intiator_index'], data['tarname'], data['portal'], data['iniIP'], data['persists'], data['mpio']
                       , data['auth'], data['IniChapUser'], data['IniChapPass'], data['TargetChapUser'], data['TargetChapPass'], data['hdigest'], data['ddigest'] ))
       

       '''status = boostLoginObj.TargetLogin( self.sid, self.ip, int(data['stack']), 1, data['tarname'], data['portal'], data['iniIP'], int(data['persists'])
                                           , int(data['mpio']), int(data['auth']), data['IniChapUser'], data['IniChapPass'], data['TargetChapUser'],
                                            data['TargetChapPass'], int(data['hdigest']), int(data['ddigest']) )'''
        
       status = boostLoginObj.TargetLogin( self.sid, self.ip, int(data['stack']), int(data['intiator_index']), data['tarname'], data['portal'], data['iniIP'], int(data['persists']), int(data['mpio']), int(data['auth']), data['IniChapUser'], data['IniChapPass'], data['TargetChapUser'],data['TargetChapPass'], int(data['hdigest']) )
       #status = 0
       
       logging.info('iSCSI Initiator Targets 3rd panel - Target Login Status : %s'%( status ))
       
       if status == 0 or status == -2: 
           return status
       else:
           return -1
       
    def get_disks(self, stack, sessid, ostype):
       self.boostIDListobj = lDiskList()
       self.boostdListobj = diskList()
       
       logging.info('iSCSI Initiator Targets 3rd panel - Get Disks : waiting for response from UMboost sid : %s , UmServerIP : %s , Stack : %s, SessionId : %s, ostype : %s\
                   '%( self.sid, self.ip, stack, sessid, ostype ))
       status = self.boostIDListobj.getDiskList( self.boostdListobj, self.sid, self.ip, int(stack), sessid, int(ostype)  )
       logging.info('iSCSI Initiator Targets 3rd panel - Get Disks status: %s'%( status ))
       
       if status == 0: 
           return self.generate_disks_html()
       elif status == -2:
           return status
       else:
           return -1
       
    def generate_disks_html(self):
        
        ip_id = self.ip.replace('.','_')
        unique_parent_id = '#iscsi_initiator_content__incend__%s .iscsi_initiator_targets_tab'%(ip_id)
        disks_html = ['<li class="disks" onclick="i_t_show_disk_details(\'%s\', $(this))">%s [ %s ]\
                        <input type = "hidden" value="%s" class="model" />\
                        <input type = "hidden" value="%s" class="vendor" />\
                        <input type = "hidden" value="%s" class="hbtl" />\
                        </li>'%( 
                            unique_parent_id,
                            self.boostIDListobj.get(self.boostdListobj,i).Identifier,
                            self.boostIDListobj.get(self.boostdListobj,i).Size,
                            self.boostIDListobj.get(self.boostdListobj,i).Model,
                            self.boostIDListobj.get(self.boostdListobj,i).Vendor,
                            self.boostIDListobj.get(self.boostdListobj,i).Hbtl)
                            for i in range(0, len(self.boostdListobj))]
        return ''.join(disks_html)

    def get_iplist(self, stack, index):
        
       self.boostiniIPListobj = iniIPList()
       self.boostipListobj = ipList()
       logging.info('iSCSI Initiator Targets - Get Ip list for windows : waiting for response from UMboost sid : %s , UmServerIP : %s , Stack : %s, Index : %s\
                   '%( self.sid, self.ip, stack, index ))
       status = self.boostiniIPListobj.getiSCSIIniIPInformation(self.boostipListobj, self.sid, self.ip, int(stack), int(index))
       logging.info('iSCSI Initiator Targets - Get Ip list for windows : %s'%( status ))
       
       if status == -2:
           return status
       elif status == 0:
            return self.generate_iplist_html()
       else:
           return -1
      
    def generate_iplist_html(self):
        
        html = '<select class="i_in_t_ip_list" >'
        for i in range(0, len(self.boostipListobj)):
            value = self.boostiniIPListobj.get(self.boostipListobj,i).Address
            logging.info('IP')
            logging.info(value)
            logging.info('IP')
            html += '<option value="%s" >%s</option>'%( value, value )
        
        html += '</select>'
        return html
    
    def get_initiators(self, stack, ostype):
       
       self.ostype = ostype 
       self.boostIniListobj = iniList()
       self.boostInitiatorListobj = initiatorList()
       logging.info('iSCSI Targets - Get Initiator : waiting for response from UMboost sid : %s , UmServerIP : %s , Stack : %s\
                   '%( self.sid, self.ip, stack ))
       status = self.boostInitiatorListobj.getiSCSIInitiatorInfo(self.boostIniListobj, self.sid, self.ip, int(stack))
       logging.info('iSCSI Targets - Get Initiator Status : %s'%( status ))
       
       if status == 0:
            return_data = {}
            if ostype == '1':
                return self.generate_initiator_html(stack)
            elif ostype == '2' or ostype == '3':
                return simplejson.dumps(self.generate_initiator_html(stack))
       elif status == -2 or status == 1:
           return status
       elif status == 19:
           return 1
       else:
           return -1
       
    def generate_initiator_html(self, stack):
        data = {}
        stack_html = ''
        html = ''
        
        if self.ostype != '1':
            unique_parent_id = '#iscsi_initiator_content__incend__%s .iscsi_initiator_targets_tab'%( self.ip.replace('.','_') )
            fn = "i_t_initiator_change('%s', '%s', $(this), '%s')"%( unique_parent_id, self.ip, self.ostype )
            html += '<select class = "i_in_t_initiator_list" onchange="%s" ><option value="" >Select One..</option>'%( fn )
        
        for i in range(0, len(self.boostIniListobj)):
            
            if stack == '22':
                initiator_name = 'Open iSCSI'
            elif stack == '23':
                initiator_name = 'Microsoft iSCSI'
            elif stack == '24':
                initiator_name = 'Chelsio iSCSI'
            elif stack == '26':
                initiator_name = 'Solaris iSCSI'
            elif stack == '27':
                initiator_name = 'Chelsio T4 iSCSI'
                
            if stack == '24' or stack == '27':
                initiator_desc = "%s: %s [ %s ]"%( initiator_name, self.boostInitiatorListobj.get(self.boostIniListobj,i).desc,
                        self.boostInitiatorListobj.get(self.boostIniListobj,i).mac )
            else:
                initiator_desc = "%s: %s"%( initiator_name, self.boostInitiatorListobj.get(self.boostIniListobj,i).InitiatorName )
                
            if i == 0:
                stack_html = '%s: %s'%( initiator_name, self.boostInitiatorListobj.get(self.boostIniListobj,i).InitiatorName )
            
            html += '<option name="%s" value="%s: %s" label="%s">%s</option>\
                    '%( i+1, initiator_name, self.boostInitiatorListobj.get(self.boostIniListobj,i).InitiatorName,
                        stack, initiator_desc )
        
        if self.ostype == '1':
            data['select_html'] = html
        else:
            data['select_html'] = html + '</select>'
        
        logging.info('----------stack_html :%s'%stack_html)
        data['stack_html'] = stack_html
        return data
    
    
    def delete_connection(self, data):
        
       self.ConnectionInfoobj = ConnectionInfo()
       
       logging.info('iSCSI Initiator Targets 3rd panel - delete connection waiting for response from UMboost\
                       sid : %s, ip : %s, Stack : %s, index : %s, sessid : %s, cid : %s\
                   '%( self.sid, self.ip, data['stack'], data['index'], data['sessid'], data['cid'] ))
       status = self.ConnectionInfoobj.DelConnection( self.sid, self.ip, int(data['stack']), int(data['index']), data['sessid'], data['cid'] )
       #status = 0
       logging.info('iSCSI Initiator Targets - delete connection status: %s'%( status ))
       
       if status == 0 or status == -2: 
           return status
       else:
           return -1
       
    def add_connection(self, data):
        
       self.ConnectionInfoobj = ConnectionInfo()
       
       logging.info('iSCSI Initiator Targets 3rd panel - add connection waiting for response from UMboost\
                       sid : %s, ip : %s, Stack : %s, index : %s, sessid : %s, initIP : %s, tarPortal : %s\
                   '%( self.sid, self.ip, data['stack'], data['index'], data['sessid'], data['initIP'], data['tarPortal'] ))
       status = self.ConnectionInfoobj.AddConnection( self.sid, self.ip, int(data['stack']), int(data['index']), data['sessid'], data['initIP'], data['tarPortal'] )
       #status = 0
       logging.info('iSCSI Initiator Targets - add connection status: %s'%( status ))
       
       if status == 0 or status == -2: 
           return status
       else:
           return -1